/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.ClusterVersionInformation;
import software.amazon.awssdk.services.eks.model.ClusterVersionListCopier;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterVersionsResponse
extends EksResponse
implements ToCopyableBuilder<Builder, DescribeClusterVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeClusterVersionsResponse.getter(DescribeClusterVersionsResponse::nextToken)).setter(DescribeClusterVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ClusterVersionInformation>> CLUSTER_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clusterVersions").getter(DescribeClusterVersionsResponse.getter(DescribeClusterVersionsResponse::clusterVersions)).setter(DescribeClusterVersionsResponse.setter(Builder::clusterVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterVersionInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CLUSTER_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeClusterVersionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ClusterVersionInformation> clusterVersions;

    private DescribeClusterVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.clusterVersions = builder.clusterVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasClusterVersions() {
        return this.clusterVersions != null && !(this.clusterVersions instanceof SdkAutoConstructList);
    }

    public final List<ClusterVersionInformation> clusterVersions() {
        return this.clusterVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterVersions() ? this.clusterVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterVersionsResponse)) {
            return false;
        }
        DescribeClusterVersionsResponse other = (DescribeClusterVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasClusterVersions() == other.hasClusterVersions() && Objects.equals(this.clusterVersions(), other.clusterVersions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterVersionsResponse").add("NextToken", (Object)this.nextToken()).add("ClusterVersions", this.hasClusterVersions() ? this.clusterVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "clusterVersions": {
                return Optional.ofNullable(clazz.cast(this.clusterVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("clusterVersions", CLUSTER_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterVersionsResponse, T> g) {
        return obj -> g.apply((DescribeClusterVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ClusterVersionInformation> clusterVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.clusterVersions(model.clusterVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ClusterVersionInformation.Builder> getClusterVersions() {
            List<ClusterVersionInformation.Builder> result = ClusterVersionListCopier.copyToBuilder(this.clusterVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterVersions(Collection<ClusterVersionInformation.BuilderImpl> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copyFromBuilder(clusterVersions);
        }

        @Override
        public final Builder clusterVersions(Collection<ClusterVersionInformation> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copy(clusterVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterVersions(ClusterVersionInformation ... clusterVersions) {
            this.clusterVersions(Arrays.asList(clusterVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterVersions(Consumer<ClusterVersionInformation.Builder> ... clusterVersions) {
            this.clusterVersions(Stream.of(clusterVersions).map(c -> (ClusterVersionInformation)((ClusterVersionInformation.Builder)ClusterVersionInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClusterVersionsResponse build() {
            return new DescribeClusterVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder clusterVersions(Collection<ClusterVersionInformation> var1);

        public Builder clusterVersions(ClusterVersionInformation ... var1);

        public Builder clusterVersions(Consumer<ClusterVersionInformation.Builder> ... var1);
    }
}

