/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscription;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscriptionListCopier;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEksAnywhereSubscriptionsResponse
extends EksResponse
implements ToCopyableBuilder<Builder, ListEksAnywhereSubscriptionsResponse> {
    private static final SdkField<List<EksAnywhereSubscription>> SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subscriptions").getter(ListEksAnywhereSubscriptionsResponse.getter(ListEksAnywhereSubscriptionsResponse::subscriptions)).setter(ListEksAnywhereSubscriptionsResponse.setter(Builder::subscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksAnywhereSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEksAnywhereSubscriptionsResponse.getter(ListEksAnywhereSubscriptionsResponse::nextToken)).setter(ListEksAnywhereSubscriptionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEksAnywhereSubscriptionsResponse.memberNameToFieldInitializer();
    private final List<EksAnywhereSubscription> subscriptions;
    private final String nextToken;

    private ListEksAnywhereSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptions = builder.subscriptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSubscriptions() {
        return this.subscriptions != null && !(this.subscriptions instanceof SdkAutoConstructList);
    }

    public final List<EksAnywhereSubscription> subscriptions() {
        return this.subscriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptions() ? this.subscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEksAnywhereSubscriptionsResponse)) {
            return false;
        }
        ListEksAnywhereSubscriptionsResponse other = (ListEksAnywhereSubscriptionsResponse)((Object)obj);
        return this.hasSubscriptions() == other.hasSubscriptions() && Objects.equals(this.subscriptions(), other.subscriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEksAnywhereSubscriptionsResponse").add("Subscriptions", this.hasSubscriptions() ? this.subscriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "subscriptions": {
                return Optional.ofNullable(clazz.cast(this.subscriptions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptions", SUBSCRIPTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEksAnywhereSubscriptionsResponse, T> g) {
        return obj -> g.apply((ListEksAnywhereSubscriptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private List<EksAnywhereSubscription> subscriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEksAnywhereSubscriptionsResponse model) {
            super(model);
            this.subscriptions(model.subscriptions);
            this.nextToken(model.nextToken);
        }

        public final List<EksAnywhereSubscription.Builder> getSubscriptions() {
            List<EksAnywhereSubscription.Builder> result = EksAnywhereSubscriptionListCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptions(Collection<EksAnywhereSubscription.BuilderImpl> subscriptions) {
            this.subscriptions = EksAnywhereSubscriptionListCopier.copyFromBuilder(subscriptions);
        }

        @Override
        public final Builder subscriptions(Collection<EksAnywhereSubscription> subscriptions) {
            this.subscriptions = EksAnywhereSubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(EksAnywhereSubscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<EksAnywhereSubscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (EksAnywhereSubscription)((EksAnywhereSubscription.Builder)EksAnywhereSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEksAnywhereSubscriptionsResponse build() {
            return new ListEksAnywhereSubscriptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEksAnywhereSubscriptionsResponse> {
        public Builder subscriptions(Collection<EksAnywhereSubscription> var1);

        public Builder subscriptions(EksAnywhereSubscription ... var1);

        public Builder subscriptions(Consumer<EksAnywhereSubscription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

