/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.ElasticLoadBalancing;
import software.amazon.awssdk.services.eks.model.IpFamily;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KubernetesNetworkConfigRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KubernetesNetworkConfigRequest> {
    private static final SdkField<String> SERVICE_IPV4_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceIpv4Cidr").getter(KubernetesNetworkConfigRequest.getter(KubernetesNetworkConfigRequest::serviceIpv4Cidr)).setter(KubernetesNetworkConfigRequest.setter(Builder::serviceIpv4Cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceIpv4Cidr").build()}).build();
    private static final SdkField<String> IP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipFamily").getter(KubernetesNetworkConfigRequest.getter(KubernetesNetworkConfigRequest::ipFamilyAsString)).setter(KubernetesNetworkConfigRequest.setter(Builder::ipFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipFamily").build()}).build();
    private static final SdkField<ElasticLoadBalancing> ELASTIC_LOAD_BALANCING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("elasticLoadBalancing").getter(KubernetesNetworkConfigRequest.getter(KubernetesNetworkConfigRequest::elasticLoadBalancing)).setter(KubernetesNetworkConfigRequest.setter(Builder::elasticLoadBalancing)).constructor(ElasticLoadBalancing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elasticLoadBalancing").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_IPV4_CIDR_FIELD, IP_FAMILY_FIELD, ELASTIC_LOAD_BALANCING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KubernetesNetworkConfigRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceIpv4Cidr;
    private final String ipFamily;
    private final ElasticLoadBalancing elasticLoadBalancing;

    private KubernetesNetworkConfigRequest(BuilderImpl builder) {
        this.serviceIpv4Cidr = builder.serviceIpv4Cidr;
        this.ipFamily = builder.ipFamily;
        this.elasticLoadBalancing = builder.elasticLoadBalancing;
    }

    public final String serviceIpv4Cidr() {
        return this.serviceIpv4Cidr;
    }

    public final IpFamily ipFamily() {
        return IpFamily.fromValue(this.ipFamily);
    }

    public final String ipFamilyAsString() {
        return this.ipFamily;
    }

    public final ElasticLoadBalancing elasticLoadBalancing() {
        return this.elasticLoadBalancing;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIpv4Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticLoadBalancing());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesNetworkConfigRequest)) {
            return false;
        }
        KubernetesNetworkConfigRequest other = (KubernetesNetworkConfigRequest)obj;
        return Objects.equals(this.serviceIpv4Cidr(), other.serviceIpv4Cidr()) && Objects.equals(this.ipFamilyAsString(), other.ipFamilyAsString()) && Objects.equals(this.elasticLoadBalancing(), other.elasticLoadBalancing());
    }

    public final String toString() {
        return ToString.builder((String)"KubernetesNetworkConfigRequest").add("ServiceIpv4Cidr", (Object)this.serviceIpv4Cidr()).add("IpFamily", (Object)this.ipFamilyAsString()).add("ElasticLoadBalancing", (Object)this.elasticLoadBalancing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceIpv4Cidr": {
                return Optional.ofNullable(clazz.cast(this.serviceIpv4Cidr()));
            }
            case "ipFamily": {
                return Optional.ofNullable(clazz.cast(this.ipFamilyAsString()));
            }
            case "elasticLoadBalancing": {
                return Optional.ofNullable(clazz.cast(this.elasticLoadBalancing()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceIpv4Cidr", SERVICE_IPV4_CIDR_FIELD);
        map.put("ipFamily", IP_FAMILY_FIELD);
        map.put("elasticLoadBalancing", ELASTIC_LOAD_BALANCING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesNetworkConfigRequest, T> g) {
        return obj -> g.apply((KubernetesNetworkConfigRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceIpv4Cidr;
        private String ipFamily;
        private ElasticLoadBalancing elasticLoadBalancing;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesNetworkConfigRequest model) {
            this.serviceIpv4Cidr(model.serviceIpv4Cidr);
            this.ipFamily(model.ipFamily);
            this.elasticLoadBalancing(model.elasticLoadBalancing);
        }

        public final String getServiceIpv4Cidr() {
            return this.serviceIpv4Cidr;
        }

        public final void setServiceIpv4Cidr(String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
        }

        @Override
        public final Builder serviceIpv4Cidr(String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
            return this;
        }

        public final String getIpFamily() {
            return this.ipFamily;
        }

        public final void setIpFamily(String ipFamily) {
            this.ipFamily = ipFamily;
        }

        @Override
        public final Builder ipFamily(String ipFamily) {
            this.ipFamily = ipFamily;
            return this;
        }

        @Override
        public final Builder ipFamily(IpFamily ipFamily) {
            this.ipFamily(ipFamily == null ? null : ipFamily.toString());
            return this;
        }

        public final ElasticLoadBalancing.Builder getElasticLoadBalancing() {
            return this.elasticLoadBalancing != null ? this.elasticLoadBalancing.toBuilder() : null;
        }

        public final void setElasticLoadBalancing(ElasticLoadBalancing.BuilderImpl elasticLoadBalancing) {
            this.elasticLoadBalancing = elasticLoadBalancing != null ? elasticLoadBalancing.build() : null;
        }

        @Override
        public final Builder elasticLoadBalancing(ElasticLoadBalancing elasticLoadBalancing) {
            this.elasticLoadBalancing = elasticLoadBalancing;
            return this;
        }

        public KubernetesNetworkConfigRequest build() {
            return new KubernetesNetworkConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KubernetesNetworkConfigRequest> {
        public Builder serviceIpv4Cidr(String var1);

        public Builder ipFamily(String var1);

        public Builder ipFamily(IpFamily var1);

        public Builder elasticLoadBalancing(ElasticLoadBalancing var1);

        default public Builder elasticLoadBalancing(Consumer<ElasticLoadBalancing.Builder> elasticLoadBalancing) {
            return this.elasticLoadBalancing((ElasticLoadBalancing)((ElasticLoadBalancing.Builder)ElasticLoadBalancing.builder().applyMutation(elasticLoadBalancing)).build());
        }
    }
}

