/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCode {
    SUBNET_NOT_FOUND("SubnetNotFound"),
    SECURITY_GROUP_NOT_FOUND("SecurityGroupNotFound"),
    ENI_LIMIT_REACHED("EniLimitReached"),
    IP_NOT_AVAILABLE("IpNotAvailable"),
    ACCESS_DENIED("AccessDenied"),
    OPERATION_NOT_PERMITTED("OperationNotPermitted"),
    VPC_ID_NOT_FOUND("VpcIdNotFound"),
    UNKNOWN("Unknown"),
    NODE_CREATION_FAILURE("NodeCreationFailure"),
    POD_EVICTION_FAILURE("PodEvictionFailure"),
    INSUFFICIENT_FREE_ADDRESSES("InsufficientFreeAddresses"),
    CLUSTER_UNREACHABLE("ClusterUnreachable"),
    INSUFFICIENT_NUMBER_OF_REPLICAS("InsufficientNumberOfReplicas"),
    CONFIGURATION_CONFLICT("ConfigurationConflict"),
    ADMISSION_REQUEST_DENIED("AdmissionRequestDenied"),
    UNSUPPORTED_ADDON_MODIFICATION("UnsupportedAddonModification"),
    K8_S_RESOURCE_NOT_FOUND("K8sResourceNotFound"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCode> VALUE_MAP;
    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        EnumSet<ErrorCode> knownValues = EnumSet.allOf(ErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCode.class, ErrorCode::toString);
    }
}

