/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest;
import software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse;

public class ListFargateProfilesIterable
implements SdkIterable<ListFargateProfilesResponse> {
    private final EksClient client;
    private final ListFargateProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFargateProfilesIterable(EksClient client, ListFargateProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFargateProfilesResponseFetcher();
    }

    public Iterator<ListFargateProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> fargateProfileNames() {
        Function<ListFargateProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fargateProfileNames() != null) {
                return response.fargateProfileNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFargateProfilesResponseFetcher
    implements SyncPageFetcher<ListFargateProfilesResponse> {
        private ListFargateProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListFargateProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFargateProfilesResponse nextPage(ListFargateProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListFargateProfilesIterable.this.client.listFargateProfiles(ListFargateProfilesIterable.this.firstRequest);
            }
            return ListFargateProfilesIterable.this.client.listFargateProfiles((ListFargateProfilesRequest)((Object)ListFargateProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

