/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.ClientStat;
import software.amazon.awssdk.services.eks.model.ClientStatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeprecationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeprecationDetail> {
    private static final SdkField<String> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usage").getter(DeprecationDetail.getter(DeprecationDetail::usage)).setter(DeprecationDetail.setter(Builder::usage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()}).build();
    private static final SdkField<String> REPLACED_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replacedWith").getter(DeprecationDetail.getter(DeprecationDetail::replacedWith)).setter(DeprecationDetail.setter(Builder::replacedWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replacedWith").build()}).build();
    private static final SdkField<String> STOP_SERVING_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stopServingVersion").getter(DeprecationDetail.getter(DeprecationDetail::stopServingVersion)).setter(DeprecationDetail.setter(Builder::stopServingVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopServingVersion").build()}).build();
    private static final SdkField<String> START_SERVING_REPLACEMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startServingReplacementVersion").getter(DeprecationDetail.getter(DeprecationDetail::startServingReplacementVersion)).setter(DeprecationDetail.setter(Builder::startServingReplacementVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startServingReplacementVersion").build()}).build();
    private static final SdkField<List<ClientStat>> CLIENT_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clientStats").getter(DeprecationDetail.getter(DeprecationDetail::clientStats)).setter(DeprecationDetail.setter(Builder::clientStats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientStats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClientStat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_FIELD, REPLACED_WITH_FIELD, STOP_SERVING_VERSION_FIELD, START_SERVING_REPLACEMENT_VERSION_FIELD, CLIENT_STATS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeprecationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String usage;
    private final String replacedWith;
    private final String stopServingVersion;
    private final String startServingReplacementVersion;
    private final List<ClientStat> clientStats;

    private DeprecationDetail(BuilderImpl builder) {
        this.usage = builder.usage;
        this.replacedWith = builder.replacedWith;
        this.stopServingVersion = builder.stopServingVersion;
        this.startServingReplacementVersion = builder.startServingReplacementVersion;
        this.clientStats = builder.clientStats;
    }

    public final String usage() {
        return this.usage;
    }

    public final String replacedWith() {
        return this.replacedWith;
    }

    public final String stopServingVersion() {
        return this.stopServingVersion;
    }

    public final String startServingReplacementVersion() {
        return this.startServingReplacementVersion;
    }

    public final boolean hasClientStats() {
        return this.clientStats != null && !(this.clientStats instanceof SdkAutoConstructList);
    }

    public final List<ClientStat> clientStats() {
        return this.clientStats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usage());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacedWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopServingVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.startServingReplacementVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientStats() ? this.clientStats() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecationDetail)) {
            return false;
        }
        DeprecationDetail other = (DeprecationDetail)obj;
        return Objects.equals(this.usage(), other.usage()) && Objects.equals(this.replacedWith(), other.replacedWith()) && Objects.equals(this.stopServingVersion(), other.stopServingVersion()) && Objects.equals(this.startServingReplacementVersion(), other.startServingReplacementVersion()) && this.hasClientStats() == other.hasClientStats() && Objects.equals(this.clientStats(), other.clientStats());
    }

    public final String toString() {
        return ToString.builder((String)"DeprecationDetail").add("Usage", (Object)this.usage()).add("ReplacedWith", (Object)this.replacedWith()).add("StopServingVersion", (Object)this.stopServingVersion()).add("StartServingReplacementVersion", (Object)this.startServingReplacementVersion()).add("ClientStats", this.hasClientStats() ? this.clientStats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usage": {
                return Optional.ofNullable(clazz.cast(this.usage()));
            }
            case "replacedWith": {
                return Optional.ofNullable(clazz.cast(this.replacedWith()));
            }
            case "stopServingVersion": {
                return Optional.ofNullable(clazz.cast(this.stopServingVersion()));
            }
            case "startServingReplacementVersion": {
                return Optional.ofNullable(clazz.cast(this.startServingReplacementVersion()));
            }
            case "clientStats": {
                return Optional.ofNullable(clazz.cast(this.clientStats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usage", USAGE_FIELD);
        map.put("replacedWith", REPLACED_WITH_FIELD);
        map.put("stopServingVersion", STOP_SERVING_VERSION_FIELD);
        map.put("startServingReplacementVersion", START_SERVING_REPLACEMENT_VERSION_FIELD);
        map.put("clientStats", CLIENT_STATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeprecationDetail, T> g) {
        return obj -> g.apply((DeprecationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String usage;
        private String replacedWith;
        private String stopServingVersion;
        private String startServingReplacementVersion;
        private List<ClientStat> clientStats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecationDetail model) {
            this.usage(model.usage);
            this.replacedWith(model.replacedWith);
            this.stopServingVersion(model.stopServingVersion);
            this.startServingReplacementVersion(model.startServingReplacementVersion);
            this.clientStats(model.clientStats);
        }

        public final String getUsage() {
            return this.usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public final String getReplacedWith() {
            return this.replacedWith;
        }

        public final void setReplacedWith(String replacedWith) {
            this.replacedWith = replacedWith;
        }

        @Override
        public final Builder replacedWith(String replacedWith) {
            this.replacedWith = replacedWith;
            return this;
        }

        public final String getStopServingVersion() {
            return this.stopServingVersion;
        }

        public final void setStopServingVersion(String stopServingVersion) {
            this.stopServingVersion = stopServingVersion;
        }

        @Override
        public final Builder stopServingVersion(String stopServingVersion) {
            this.stopServingVersion = stopServingVersion;
            return this;
        }

        public final String getStartServingReplacementVersion() {
            return this.startServingReplacementVersion;
        }

        public final void setStartServingReplacementVersion(String startServingReplacementVersion) {
            this.startServingReplacementVersion = startServingReplacementVersion;
        }

        @Override
        public final Builder startServingReplacementVersion(String startServingReplacementVersion) {
            this.startServingReplacementVersion = startServingReplacementVersion;
            return this;
        }

        public final List<ClientStat.Builder> getClientStats() {
            List<ClientStat.Builder> result = ClientStatsCopier.copyToBuilder(this.clientStats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientStats(Collection<ClientStat.BuilderImpl> clientStats) {
            this.clientStats = ClientStatsCopier.copyFromBuilder(clientStats);
        }

        @Override
        public final Builder clientStats(Collection<ClientStat> clientStats) {
            this.clientStats = ClientStatsCopier.copy(clientStats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientStats(ClientStat ... clientStats) {
            this.clientStats(Arrays.asList(clientStats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientStats(Consumer<ClientStat.Builder> ... clientStats) {
            this.clientStats(Stream.of(clientStats).map(c -> (ClientStat)((ClientStat.Builder)ClientStat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DeprecationDetail build() {
            return new DeprecationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeprecationDetail> {
        public Builder usage(String var1);

        public Builder replacedWith(String var1);

        public Builder stopServingVersion(String var1);

        public Builder startServingReplacementVersion(String var1);

        public Builder clientStats(Collection<ClientStat> var1);

        public Builder clientStats(ClientStat ... var1);

        public Builder clientStats(Consumer<ClientStat.Builder> ... var1);
    }
}

