/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.IdentityProviderConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateIdentityProviderConfigRequest
extends EksRequest
implements ToCopyableBuilder<Builder, DisassociateIdentityProviderConfigRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(DisassociateIdentityProviderConfigRequest.getter(DisassociateIdentityProviderConfigRequest::clusterName)).setter(DisassociateIdentityProviderConfigRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<IdentityProviderConfig> IDENTITY_PROVIDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identityProviderConfig").getter(DisassociateIdentityProviderConfigRequest.getter(DisassociateIdentityProviderConfigRequest::identityProviderConfig)).setter(DisassociateIdentityProviderConfigRequest.setter(Builder::identityProviderConfig)).constructor(IdentityProviderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfig").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(DisassociateIdentityProviderConfigRequest.getter(DisassociateIdentityProviderConfigRequest::clientRequestToken)).setter(DisassociateIdentityProviderConfigRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, IDENTITY_PROVIDER_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String clusterName;
    private final IdentityProviderConfig identityProviderConfig;
    private final String clientRequestToken;

    private DisassociateIdentityProviderConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.identityProviderConfig = builder.identityProviderConfig;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final IdentityProviderConfig identityProviderConfig() {
        return this.identityProviderConfig;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateIdentityProviderConfigRequest)) {
            return false;
        }
        DisassociateIdentityProviderConfigRequest other = (DisassociateIdentityProviderConfigRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.identityProviderConfig(), other.identityProviderConfig()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateIdentityProviderConfigRequest").add("ClusterName", (Object)this.clusterName()).add("IdentityProviderConfig", (Object)this.identityProviderConfig()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "identityProviderConfig": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfig()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateIdentityProviderConfigRequest, T> g) {
        return obj -> g.apply((DisassociateIdentityProviderConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private IdentityProviderConfig identityProviderConfig;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateIdentityProviderConfigRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.identityProviderConfig(model.identityProviderConfig);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final IdentityProviderConfig.Builder getIdentityProviderConfig() {
            return this.identityProviderConfig != null ? this.identityProviderConfig.toBuilder() : null;
        }

        public final void setIdentityProviderConfig(IdentityProviderConfig.BuilderImpl identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig != null ? identityProviderConfig.build() : null;
        }

        @Override
        public final Builder identityProviderConfig(IdentityProviderConfig identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateIdentityProviderConfigRequest build() {
            return new DisassociateIdentityProviderConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateIdentityProviderConfigRequest> {
        public Builder clusterName(String var1);

        public Builder identityProviderConfig(IdentityProviderConfig var1);

        default public Builder identityProviderConfig(Consumer<IdentityProviderConfig.Builder> identityProviderConfig) {
            return this.identityProviderConfig((IdentityProviderConfig)((IdentityProviderConfig.Builder)IdentityProviderConfig.builder().applyMutation(identityProviderConfig)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

