/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.model.AddonInfo;
import software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest;
import software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse;

public class DescribeAddonVersionsIterable
implements SdkIterable<DescribeAddonVersionsResponse> {
    private final EksClient client;
    private final DescribeAddonVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAddonVersionsIterable(EksClient client, DescribeAddonVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAddonVersionsResponseFetcher();
    }

    public Iterator<DescribeAddonVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AddonInfo> addons() {
        Function<DescribeAddonVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.addons() != null) {
                return response.addons().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAddonVersionsResponseFetcher
    implements SyncPageFetcher<DescribeAddonVersionsResponse> {
        private DescribeAddonVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAddonVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAddonVersionsResponse nextPage(DescribeAddonVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAddonVersionsIterable.this.client.describeAddonVersions(DescribeAddonVersionsIterable.this.firstRequest);
            }
            return DescribeAddonVersionsIterable.this.client.describeAddonVersions((DescribeAddonVersionsRequest)((Object)DescribeAddonVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

