/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MarketplaceInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MarketplaceInformation> {
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productId").getter(MarketplaceInformation.getter(MarketplaceInformation::productId)).setter(MarketplaceInformation.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productId").build()}).build();
    private static final SdkField<String> PRODUCT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productUrl").getter(MarketplaceInformation.getter(MarketplaceInformation::productUrl)).setter(MarketplaceInformation.setter(Builder::productUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ID_FIELD, PRODUCT_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String productId;
    private final String productUrl;

    private MarketplaceInformation(BuilderImpl builder) {
        this.productId = builder.productId;
        this.productUrl = builder.productUrl;
    }

    public final String productId() {
        return this.productId;
    }

    public final String productUrl() {
        return this.productUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MarketplaceInformation)) {
            return false;
        }
        MarketplaceInformation other = (MarketplaceInformation)obj;
        return Objects.equals(this.productId(), other.productId()) && Objects.equals(this.productUrl(), other.productUrl());
    }

    public final String toString() {
        return ToString.builder((String)"MarketplaceInformation").add("ProductId", (Object)this.productId()).add("ProductUrl", (Object)this.productUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "productId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "productUrl": {
                return Optional.ofNullable(clazz.cast(this.productUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MarketplaceInformation, T> g) {
        return obj -> g.apply((MarketplaceInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productId;
        private String productUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(MarketplaceInformation model) {
            this.productId(model.productId);
            this.productUrl(model.productUrl);
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductUrl() {
            return this.productUrl;
        }

        public final void setProductUrl(String productUrl) {
            this.productUrl = productUrl;
        }

        @Override
        public final Builder productUrl(String productUrl) {
            this.productUrl = productUrl;
            return this;
        }

        public MarketplaceInformation build() {
            return new MarketplaceInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MarketplaceInformation> {
        public Builder productId(String var1);

        public Builder productUrl(String var1);
    }
}

