/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFargateProfilesResponse
extends EksResponse
implements ToCopyableBuilder<Builder, ListFargateProfilesResponse> {
    private static final SdkField<List<String>> FARGATE_PROFILE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fargateProfileNames").getter(ListFargateProfilesResponse.getter(ListFargateProfilesResponse::fargateProfileNames)).setter(ListFargateProfilesResponse.setter(Builder::fargateProfileNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFargateProfilesResponse.getter(ListFargateProfilesResponse::nextToken)).setter(ListFargateProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARGATE_PROFILE_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> fargateProfileNames;
    private final String nextToken;

    private ListFargateProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.fargateProfileNames = builder.fargateProfileNames;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFargateProfileNames() {
        return this.fargateProfileNames != null && !(this.fargateProfileNames instanceof SdkAutoConstructList);
    }

    public final List<String> fargateProfileNames() {
        return this.fargateProfileNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFargateProfileNames() ? this.fargateProfileNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFargateProfilesResponse)) {
            return false;
        }
        ListFargateProfilesResponse other = (ListFargateProfilesResponse)((Object)obj);
        return this.hasFargateProfileNames() == other.hasFargateProfileNames() && Objects.equals(this.fargateProfileNames(), other.fargateProfileNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFargateProfilesResponse").add("FargateProfileNames", this.hasFargateProfileNames() ? this.fargateProfileNames() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fargateProfileNames": {
                return Optional.ofNullable(clazz.cast(this.fargateProfileNames()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFargateProfilesResponse, T> g) {
        return obj -> g.apply((ListFargateProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private List<String> fargateProfileNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFargateProfilesResponse model) {
            super(model);
            this.fargateProfileNames(model.fargateProfileNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getFargateProfileNames() {
            if (this.fargateProfileNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fargateProfileNames;
        }

        public final void setFargateProfileNames(Collection<String> fargateProfileNames) {
            this.fargateProfileNames = StringListCopier.copy(fargateProfileNames);
        }

        @Override
        @Transient
        public final Builder fargateProfileNames(Collection<String> fargateProfileNames) {
            this.fargateProfileNames = StringListCopier.copy(fargateProfileNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fargateProfileNames(String ... fargateProfileNames) {
            this.fargateProfileNames(Arrays.asList(fargateProfileNames));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFargateProfilesResponse build() {
            return new ListFargateProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFargateProfilesResponse> {
        public Builder fargateProfileNames(Collection<String> var1);

        public Builder fargateProfileNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

