/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the AWS Key Management Service (AWS KMS) customer master key (CMK) used to encrypt the secrets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Provider implements SdkPojo, Serializable, ToCopyableBuilder<Provider.Builder, Provider> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("keyArn")
            .getter(getter(Provider::keyArn)).setter(setter(Builder::keyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyArn;

    private Provider(BuilderImpl builder) {
        this.keyArn = builder.keyArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) or alias of the customer master key (CMK). The CMK must be symmetric, created in the
     * same region as the cluster, and if the CMK was created in a different account, the user must have access to the
     * CMK. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html">Allowing
     * Users in Other Accounts to Use a CMK</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) or alias of the customer master key (CMK). The CMK must be symmetric, created
     *         in the same region as the cluster, and if the CMK was created in a different account, the user must have
     *         access to the CMK. For more information, see <a href=
     *         "https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html"
     *         >Allowing Users in Other Accounts to Use a CMK</a> in the <i>AWS Key Management Service Developer
     *         Guide</i>.
     */
    public final String keyArn() {
        return keyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Provider)) {
            return false;
        }
        Provider other = (Provider) obj;
        return Objects.equals(keyArn(), other.keyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Provider").add("KeyArn", keyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyArn":
            return Optional.ofNullable(clazz.cast(keyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Provider, T> g) {
        return obj -> g.apply((Provider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Provider> {
        /**
         * <p>
         * Amazon Resource Name (ARN) or alias of the customer master key (CMK). The CMK must be symmetric, created in
         * the same region as the cluster, and if the CMK was created in a different account, the user must have access
         * to the CMK. For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html"
         * >Allowing Users in Other Accounts to Use a CMK</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param keyArn
         *        Amazon Resource Name (ARN) or alias of the customer master key (CMK). The CMK must be symmetric,
         *        created in the same region as the cluster, and if the CMK was created in a different account, the user
         *        must have access to the CMK. For more information, see <a href=
         *        "https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html"
         *        >Allowing Users in Other Accounts to Use a CMK</a> in the <i>AWS Key Management Service Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);
    }

    static final class BuilderImpl implements Builder {
        private String keyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Provider model) {
            keyArn(model.keyArn);
        }

        public final String getKeyArn() {
            return keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public Provider build() {
            return new Provider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
