/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an add-on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddonInfo implements SdkPojo, Serializable, ToCopyableBuilder<AddonInfo.Builder, AddonInfo> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonName").getter(getter(AddonInfo::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AddonInfo::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<AddonVersionInfo>> ADDON_VERSIONS_FIELD = SdkField
            .<List<AddonVersionInfo>> builder(MarshallingType.LIST)
            .memberName("addonVersions")
            .getter(getter(AddonInfo::addonVersions))
            .setter(setter(Builder::addonVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddonVersionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddonVersionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD, TYPE_FIELD,
            ADDON_VERSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addonName;

    private final String type;

    private final List<AddonVersionInfo> addonVersions;

    private AddonInfo(BuilderImpl builder) {
        this.addonName = builder.addonName;
        this.type = builder.type;
        this.addonVersions = builder.addonVersions;
    }

    /**
     * <p>
     * The name of the add-on.
     * </p>
     * 
     * @return The name of the add-on.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * The type of the add-on.
     * </p>
     * 
     * @return The type of the add-on.
     */
    public final String type() {
        return type;
    }

    /**
     * Returns true if the AddonVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAddonVersions() {
        return addonVersions != null && !(addonVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that represents information about available add-on versions and compatible Kubernetes versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddonVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that represents information about available add-on versions and compatible Kubernetes versions.
     */
    public final List<AddonVersionInfo> addonVersions() {
        return addonVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddonVersions() ? addonVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonInfo)) {
            return false;
        }
        AddonInfo other = (AddonInfo) obj;
        return Objects.equals(addonName(), other.addonName()) && Objects.equals(type(), other.type())
                && hasAddonVersions() == other.hasAddonVersions() && Objects.equals(addonVersions(), other.addonVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddonInfo").add("AddonName", addonName()).add("Type", type())
                .add("AddonVersions", hasAddonVersions() ? addonVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "addonVersions":
            return Optional.ofNullable(clazz.cast(addonVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddonInfo, T> g) {
        return obj -> g.apply((AddonInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddonInfo> {
        /**
         * <p>
         * The name of the add-on.
         * </p>
         * 
         * @param addonName
         *        The name of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * The type of the add-on.
         * </p>
         * 
         * @param type
         *        The type of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * An object that represents information about available add-on versions and compatible Kubernetes versions.
         * </p>
         * 
         * @param addonVersions
         *        An object that represents information about available add-on versions and compatible Kubernetes
         *        versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersions(Collection<AddonVersionInfo> addonVersions);

        /**
         * <p>
         * An object that represents information about available add-on versions and compatible Kubernetes versions.
         * </p>
         * 
         * @param addonVersions
         *        An object that represents information about available add-on versions and compatible Kubernetes
         *        versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersions(AddonVersionInfo... addonVersions);

        /**
         * <p>
         * An object that represents information about available add-on versions and compatible Kubernetes versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AddonVersionInfo>.Builder} avoiding the
         * need to create one manually via {@link List<AddonVersionInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddonVersionInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #addonVersions(List<AddonVersionInfo>)}.
         * 
         * @param addonVersions
         *        a consumer that will call methods on {@link List<AddonVersionInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addonVersions(List<AddonVersionInfo>)
         */
        Builder addonVersions(Consumer<AddonVersionInfo.Builder>... addonVersions);
    }

    static final class BuilderImpl implements Builder {
        private String addonName;

        private String type;

        private List<AddonVersionInfo> addonVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddonInfo model) {
            addonName(model.addonName);
            type(model.type);
            addonVersions(model.addonVersions);
        }

        public final String getAddonName() {
            return addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<AddonVersionInfo.Builder> getAddonVersions() {
            if (addonVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return addonVersions != null ? addonVersions.stream().map(AddonVersionInfo::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder addonVersions(Collection<AddonVersionInfo> addonVersions) {
            this.addonVersions = AddonVersionInfoListCopier.copy(addonVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonVersions(AddonVersionInfo... addonVersions) {
            addonVersions(Arrays.asList(addonVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonVersions(Consumer<AddonVersionInfo.Builder>... addonVersions) {
            addonVersions(Stream.of(addonVersions).map(c -> AddonVersionInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAddonVersions(Collection<AddonVersionInfo.BuilderImpl> addonVersions) {
            this.addonVersions = AddonVersionInfoListCopier.copyFromBuilder(addonVersions);
        }

        @Override
        public AddonInfo build() {
            return new AddonInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
