/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUpdatesResponse extends EksResponse implements
        ToCopyableBuilder<ListUpdatesResponse.Builder, ListUpdatesResponse> {
    private static final SdkField<List<String>> UPDATE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListUpdatesResponse::updateIds))
            .setter(setter(Builder::updateIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUpdatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> updateIds;

    private final String nextToken;

    private ListUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.updateIds = builder.updateIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the UpdateIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUpdateIds() {
        return updateIds != null && !(updateIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all the updates for the specified cluster and Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdateIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all the updates for the specified cluster and Region.
     */
    public List<String> updateIds() {
        return updateIds;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the results of a
     * <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page
     * of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the
     *         results of a <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value to
     *         retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUpdatesResponse)) {
            return false;
        }
        ListUpdatesResponse other = (ListUpdatesResponse) obj;
        return Objects.equals(updateIds(), other.updateIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUpdatesResponse").add("UpdateIds", updateIds()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "updateIds":
            return Optional.ofNullable(clazz.cast(updateIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUpdatesResponse, T> g) {
        return obj -> g.apply((ListUpdatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUpdatesResponse> {
        /**
         * <p>
         * A list of all the updates for the specified cluster and Region.
         * </p>
         * 
         * @param updateIds
         *        A list of all the updates for the specified cluster and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateIds(Collection<String> updateIds);

        /**
         * <p>
         * A list of all the updates for the specified cluster and Region.
         * </p>
         * 
         * @param updateIds
         *        A list of all the updates for the specified cluster and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateIds(String... updateIds);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the results of
         * a <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value to retrieve the
         * next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the
         *        results of a <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value
         *        to retrieve the next page of results. This value is <code>null</code> when there are no more results
         *        to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<String> updateIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUpdatesResponse model) {
            super(model);
            updateIds(model.updateIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getUpdateIds() {
            return updateIds;
        }

        @Override
        public final Builder updateIds(Collection<String> updateIds) {
            this.updateIds = StringListCopier.copy(updateIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateIds(String... updateIds) {
            updateIds(Arrays.asList(updateIds));
            return this;
        }

        public final void setUpdateIds(Collection<String> updateIds) {
            this.updateIds = StringListCopier.copy(updateIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUpdatesResponse build() {
            return new ListUpdatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
