/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFargateProfilesResponse extends EksResponse implements
        ToCopyableBuilder<ListFargateProfilesResponse.Builder, ListFargateProfilesResponse> {
    private static final SdkField<List<String>> FARGATE_PROFILE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListFargateProfilesResponse::fargateProfileNames))
            .setter(setter(Builder::fargateProfileNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFargateProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARGATE_PROFILE_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> fargateProfileNames;

    private final String nextToken;

    private ListFargateProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.fargateProfileNames = builder.fargateProfileNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FargateProfileNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFargateProfileNames() {
        return fargateProfileNames != null && !(fargateProfileNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all of the Fargate profiles associated with the specified cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFargateProfileNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all of the Fargate profiles associated with the specified cluster.
     */
    public List<String> fargateProfileNames() {
        return fargateProfileNames;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListFargateProfiles</code> request. When the
     * results of a <code>ListFargateProfiles</code> request exceed <code>maxResults</code>, you can use this value to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListFargateProfiles</code> request. When
     *         the results of a <code>ListFargateProfiles</code> request exceed <code>maxResults</code>, you can use
     *         this value to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fargateProfileNames());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFargateProfilesResponse)) {
            return false;
        }
        ListFargateProfilesResponse other = (ListFargateProfilesResponse) obj;
        return Objects.equals(fargateProfileNames(), other.fargateProfileNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFargateProfilesResponse").add("FargateProfileNames", fargateProfileNames())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fargateProfileNames":
            return Optional.ofNullable(clazz.cast(fargateProfileNames()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFargateProfilesResponse, T> g) {
        return obj -> g.apply((ListFargateProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFargateProfilesResponse> {
        /**
         * <p>
         * A list of all of the Fargate profiles associated with the specified cluster.
         * </p>
         * 
         * @param fargateProfileNames
         *        A list of all of the Fargate profiles associated with the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfileNames(Collection<String> fargateProfileNames);

        /**
         * <p>
         * A list of all of the Fargate profiles associated with the specified cluster.
         * </p>
         * 
         * @param fargateProfileNames
         *        A list of all of the Fargate profiles associated with the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfileNames(String... fargateProfileNames);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListFargateProfiles</code> request. When the
         * results of a <code>ListFargateProfiles</code> request exceed <code>maxResults</code>, you can use this value
         * to retrieve the next page of results. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListFargateProfiles</code> request. When
         *        the results of a <code>ListFargateProfiles</code> request exceed <code>maxResults</code>, you can use
         *        this value to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<String> fargateProfileNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFargateProfilesResponse model) {
            super(model);
            fargateProfileNames(model.fargateProfileNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getFargateProfileNames() {
            return fargateProfileNames;
        }

        @Override
        public final Builder fargateProfileNames(Collection<String> fargateProfileNames) {
            this.fargateProfileNames = StringListCopier.copy(fargateProfileNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fargateProfileNames(String... fargateProfileNames) {
            fargateProfileNames(Arrays.asList(fargateProfileNames));
            return this;
        }

        public final void setFargateProfileNames(Collection<String> fargateProfileNames) {
            this.fargateProfileNames = StringListCopier.copy(fargateProfileNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFargateProfilesResponse build() {
            return new ListFargateProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
