/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.efs.EfsClient;
import software.amazon.awssdk.services.efs.internal.UserAgentUtils;
import software.amazon.awssdk.services.efs.model.AccessPointDescription;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse;

public class DescribeAccessPointsIterable
implements SdkIterable<DescribeAccessPointsResponse> {
    private final EfsClient client;
    private final DescribeAccessPointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAccessPointsIterable(EfsClient client, DescribeAccessPointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAccessPointsResponseFetcher();
    }

    public Iterator<DescribeAccessPointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessPointDescription> accessPoints() {
        Function<DescribeAccessPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessPoints() != null) {
                return response.accessPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAccessPointsResponseFetcher
    implements SyncPageFetcher<DescribeAccessPointsResponse> {
        private DescribeAccessPointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAccessPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAccessPointsResponse nextPage(DescribeAccessPointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAccessPointsIterable.this.client.describeAccessPoints(DescribeAccessPointsIterable.this.firstRequest);
            }
            return DescribeAccessPointsIterable.this.client.describeAccessPoints((DescribeAccessPointsRequest)((Object)DescribeAccessPointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

