/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.services.efs.model.ResourceIdPreference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountPreferencesResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, DescribeAccountPreferencesResponse> {
    private static final SdkField<ResourceIdPreference> RESOURCE_ID_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceIdPreference").getter(DescribeAccountPreferencesResponse.getter(DescribeAccountPreferencesResponse::resourceIdPreference)).setter(DescribeAccountPreferencesResponse.setter(Builder::resourceIdPreference)).constructor(ResourceIdPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdPreference").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAccountPreferencesResponse.getter(DescribeAccountPreferencesResponse::nextToken)).setter(DescribeAccountPreferencesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_PREFERENCE_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAccountPreferencesResponse.memberNameToFieldInitializer();
    private final ResourceIdPreference resourceIdPreference;
    private final String nextToken;

    private DescribeAccountPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdPreference = builder.resourceIdPreference;
        this.nextToken = builder.nextToken;
    }

    public final ResourceIdPreference resourceIdPreference() {
        return this.resourceIdPreference;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountPreferencesResponse)) {
            return false;
        }
        DescribeAccountPreferencesResponse other = (DescribeAccountPreferencesResponse)((Object)obj);
        return Objects.equals(this.resourceIdPreference(), other.resourceIdPreference()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountPreferencesResponse").add("ResourceIdPreference", (Object)this.resourceIdPreference()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdPreference": {
                return Optional.ofNullable(clazz.cast(this.resourceIdPreference()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceIdPreference", RESOURCE_ID_PREFERENCE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountPreferencesResponse, T> g) {
        return obj -> g.apply((DescribeAccountPreferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private ResourceIdPreference resourceIdPreference;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountPreferencesResponse model) {
            super(model);
            this.resourceIdPreference(model.resourceIdPreference);
            this.nextToken(model.nextToken);
        }

        public final ResourceIdPreference.Builder getResourceIdPreference() {
            return this.resourceIdPreference != null ? this.resourceIdPreference.toBuilder() : null;
        }

        public final void setResourceIdPreference(ResourceIdPreference.BuilderImpl resourceIdPreference) {
            this.resourceIdPreference = resourceIdPreference != null ? resourceIdPreference.build() : null;
        }

        @Override
        public final Builder resourceIdPreference(ResourceIdPreference resourceIdPreference) {
            this.resourceIdPreference = resourceIdPreference;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAccountPreferencesResponse build() {
            return new DescribeAccountPreferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EfsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountPreferencesResponse> {
        public Builder resourceIdPreference(ResourceIdPreference var1);

        default public Builder resourceIdPreference(Consumer<ResourceIdPreference.Builder> resourceIdPreference) {
            return this.resourceIdPreference((ResourceIdPreference)((ResourceIdPreference.Builder)ResourceIdPreference.builder().applyMutation(resourceIdPreference)).build());
        }

        public Builder nextToken(String var1);
    }
}

