/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription;
import software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationConfigurationsResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, DescribeReplicationConfigurationsResponse> {
    private static final SdkField<List<ReplicationConfigurationDescription>> REPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Replications").getter(DescribeReplicationConfigurationsResponse.getter(DescribeReplicationConfigurationsResponse::replications)).setter(DescribeReplicationConfigurationsResponse.setter(Builder::replications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReplicationConfigurationsResponse.getter(DescribeReplicationConfigurationsResponse::nextToken)).setter(DescribeReplicationConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeReplicationConfigurationsResponse.memberNameToFieldInitializer();
    private final List<ReplicationConfigurationDescription> replications;
    private final String nextToken;

    private DescribeReplicationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.replications = builder.replications;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReplications() {
        return this.replications != null && !(this.replications instanceof SdkAutoConstructList);
    }

    public final List<ReplicationConfigurationDescription> replications() {
        return this.replications;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplications() ? this.replications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationConfigurationsResponse)) {
            return false;
        }
        DescribeReplicationConfigurationsResponse other = (DescribeReplicationConfigurationsResponse)((Object)obj);
        return this.hasReplications() == other.hasReplications() && Objects.equals(this.replications(), other.replications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplicationConfigurationsResponse").add("Replications", this.hasReplications() ? this.replications() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Replications": {
                return Optional.ofNullable(clazz.cast(this.replications()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Replications", REPLICATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private List<ReplicationConfigurationDescription> replications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationConfigurationsResponse model) {
            super(model);
            this.replications(model.replications);
            this.nextToken(model.nextToken);
        }

        public final List<ReplicationConfigurationDescription.Builder> getReplications() {
            List<ReplicationConfigurationDescription.Builder> result = ReplicationConfigurationDescriptionsCopier.copyToBuilder(this.replications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplications(Collection<ReplicationConfigurationDescription.BuilderImpl> replications) {
            this.replications = ReplicationConfigurationDescriptionsCopier.copyFromBuilder(replications);
        }

        @Override
        public final Builder replications(Collection<ReplicationConfigurationDescription> replications) {
            this.replications = ReplicationConfigurationDescriptionsCopier.copy(replications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replications(ReplicationConfigurationDescription ... replications) {
            this.replications(Arrays.asList(replications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replications(Consumer<ReplicationConfigurationDescription.Builder> ... replications) {
            this.replications(Stream.of(replications).map(c -> (ReplicationConfigurationDescription)((ReplicationConfigurationDescription.Builder)ReplicationConfigurationDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeReplicationConfigurationsResponse build() {
            return new DescribeReplicationConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EfsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationConfigurationsResponse> {
        public Builder replications(Collection<ReplicationConfigurationDescription> var1);

        public Builder replications(ReplicationConfigurationDescription ... var1);

        public Builder replications(Consumer<ReplicationConfigurationDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

