/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.ReplicationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Destination> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Destination.getter(Destination::statusAsString)).setter(Destination.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(Destination.getter(Destination::fileSystemId)).setter(Destination.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Destination.getter(Destination::region)).setter(Destination.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<Instant> LAST_REPLICATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastReplicatedTimestamp").getter(Destination.getter(Destination::lastReplicatedTimestamp)).setter(Destination.setter(Builder::lastReplicatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastReplicatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FILE_SYSTEM_ID_FIELD, REGION_FIELD, LAST_REPLICATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
            this.put("Region", REGION_FIELD);
            this.put("LastReplicatedTimestamp", LAST_REPLICATED_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String fileSystemId;
    private final String region;
    private final Instant lastReplicatedTimestamp;

    private Destination(BuilderImpl builder) {
        this.status = builder.status;
        this.fileSystemId = builder.fileSystemId;
        this.region = builder.region;
        this.lastReplicatedTimestamp = builder.lastReplicatedTimestamp;
    }

    public final ReplicationStatus status() {
        return ReplicationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String region() {
        return this.region;
    }

    public final Instant lastReplicatedTimestamp() {
        return this.lastReplicatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastReplicatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.lastReplicatedTimestamp(), other.lastReplicatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"Destination").add("Status", (Object)this.statusAsString()).add("FileSystemId", (Object)this.fileSystemId()).add("Region", (Object)this.region()).add("LastReplicatedTimestamp", (Object)this.lastReplicatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "LastReplicatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastReplicatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String fileSystemId;
        private String region;
        private Instant lastReplicatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.status(model.status);
            this.fileSystemId(model.fileSystemId);
            this.region(model.region);
            this.lastReplicatedTimestamp(model.lastReplicatedTimestamp);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Instant getLastReplicatedTimestamp() {
            return this.lastReplicatedTimestamp;
        }

        public final void setLastReplicatedTimestamp(Instant lastReplicatedTimestamp) {
            this.lastReplicatedTimestamp = lastReplicatedTimestamp;
        }

        @Override
        public final Builder lastReplicatedTimestamp(Instant lastReplicatedTimestamp) {
            this.lastReplicatedTimestamp = lastReplicatedTimestamp;
            return this;
        }

        public Destination build() {
            return new Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Destination> {
        public Builder status(String var1);

        public Builder status(ReplicationStatus var1);

        public Builder fileSystemId(String var1);

        public Builder region(String var1);

        public Builder lastReplicatedTimestamp(Instant var1);
    }
}

