/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.LifeCycleState;
import software.amazon.awssdk.services.efs.model.PosixUser;
import software.amazon.awssdk.services.efs.model.RootDirectory;
import software.amazon.awssdk.services.efs.model.Tag;
import software.amazon.awssdk.services.efs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessPointDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessPointDescription> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AccessPointDescription.getter(AccessPointDescription::clientToken)).setter(AccessPointDescription.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AccessPointDescription.getter(AccessPointDescription::name)).setter(AccessPointDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(AccessPointDescription.getter(AccessPointDescription::tags)).setter(AccessPointDescription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointId").getter(AccessPointDescription.getter(AccessPointDescription::accessPointId)).setter(AccessPointDescription.setter(Builder::accessPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointId").build()}).build();
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointArn").getter(AccessPointDescription.getter(AccessPointDescription::accessPointArn)).setter(AccessPointDescription.setter(Builder::accessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(AccessPointDescription.getter(AccessPointDescription::fileSystemId)).setter(AccessPointDescription.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<PosixUser> POSIX_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PosixUser").getter(AccessPointDescription.getter(AccessPointDescription::posixUser)).setter(AccessPointDescription.setter(Builder::posixUser)).constructor(PosixUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixUser").build()}).build();
    private static final SdkField<RootDirectory> ROOT_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootDirectory").getter(AccessPointDescription.getter(AccessPointDescription::rootDirectory)).setter(AccessPointDescription.setter(Builder::rootDirectory)).constructor(RootDirectory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDirectory").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(AccessPointDescription.getter(AccessPointDescription::ownerId)).setter(AccessPointDescription.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifeCycleState").getter(AccessPointDescription.getter(AccessPointDescription::lifeCycleStateAsString)).setter(AccessPointDescription.setter(Builder::lifeCycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NAME_FIELD, TAGS_FIELD, ACCESS_POINT_ID_FIELD, ACCESS_POINT_ARN_FIELD, FILE_SYSTEM_ID_FIELD, POSIX_USER_FIELD, ROOT_DIRECTORY_FIELD, OWNER_ID_FIELD, LIFE_CYCLE_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientToken;
    private final String name;
    private final List<Tag> tags;
    private final String accessPointId;
    private final String accessPointArn;
    private final String fileSystemId;
    private final PosixUser posixUser;
    private final RootDirectory rootDirectory;
    private final String ownerId;
    private final String lifeCycleState;

    private AccessPointDescription(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.tags = builder.tags;
        this.accessPointId = builder.accessPointId;
        this.accessPointArn = builder.accessPointArn;
        this.fileSystemId = builder.fileSystemId;
        this.posixUser = builder.posixUser;
        this.rootDirectory = builder.rootDirectory;
        this.ownerId = builder.ownerId;
        this.lifeCycleState = builder.lifeCycleState;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String accessPointId() {
        return this.accessPointId;
    }

    public final String accessPointArn() {
        return this.accessPointArn;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final PosixUser posixUser() {
        return this.posixUser;
    }

    public final RootDirectory rootDirectory() {
        return this.rootDirectory;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(this.lifeCycleState);
    }

    public final String lifeCycleStateAsString() {
        return this.lifeCycleState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.posixUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPointDescription)) {
            return false;
        }
        AccessPointDescription other = (AccessPointDescription)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.accessPointId(), other.accessPointId()) && Objects.equals(this.accessPointArn(), other.accessPointArn()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.posixUser(), other.posixUser()) && Objects.equals(this.rootDirectory(), other.rootDirectory()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.lifeCycleStateAsString(), other.lifeCycleStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccessPointDescription").add("ClientToken", (Object)this.clientToken()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).add("AccessPointId", (Object)this.accessPointId()).add("AccessPointArn", (Object)this.accessPointArn()).add("FileSystemId", (Object)this.fileSystemId()).add("PosixUser", (Object)this.posixUser()).add("RootDirectory", (Object)this.rootDirectory()).add("OwnerId", (Object)this.ownerId()).add("LifeCycleState", (Object)this.lifeCycleStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AccessPointId": {
                return Optional.ofNullable(clazz.cast(this.accessPointId()));
            }
            case "AccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.accessPointArn()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "PosixUser": {
                return Optional.ofNullable(clazz.cast(this.posixUser()));
            }
            case "RootDirectory": {
                return Optional.ofNullable(clazz.cast(this.rootDirectory()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "LifeCycleState": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPointDescription, T> g) {
        return obj -> g.apply((AccessPointDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private String name;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String accessPointId;
        private String accessPointArn;
        private String fileSystemId;
        private PosixUser posixUser;
        private RootDirectory rootDirectory;
        private String ownerId;
        private String lifeCycleState;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPointDescription model) {
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.tags(model.tags);
            this.accessPointId(model.accessPointId);
            this.accessPointArn(model.accessPointArn);
            this.fileSystemId(model.fileSystemId);
            this.posixUser(model.posixUser);
            this.rootDirectory(model.rootDirectory);
            this.ownerId(model.ownerId);
            this.lifeCycleState(model.lifeCycleState);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAccessPointId() {
            return this.accessPointId;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        @Override
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final String getAccessPointArn() {
            return this.accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final PosixUser.Builder getPosixUser() {
            return this.posixUser != null ? this.posixUser.toBuilder() : null;
        }

        public final void setPosixUser(PosixUser.BuilderImpl posixUser) {
            this.posixUser = posixUser != null ? posixUser.build() : null;
        }

        @Override
        public final Builder posixUser(PosixUser posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        public final RootDirectory.Builder getRootDirectory() {
            return this.rootDirectory != null ? this.rootDirectory.toBuilder() : null;
        }

        public final void setRootDirectory(RootDirectory.BuilderImpl rootDirectory) {
            this.rootDirectory = rootDirectory != null ? rootDirectory.build() : null;
        }

        @Override
        public final Builder rootDirectory(RootDirectory rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getLifeCycleState() {
            return this.lifeCycleState;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        public AccessPointDescription build() {
            return new AccessPointDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessPointDescription> {
        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder accessPointId(String var1);

        public Builder accessPointArn(String var1);

        public Builder fileSystemId(String var1);

        public Builder posixUser(PosixUser var1);

        default public Builder posixUser(Consumer<PosixUser.Builder> posixUser) {
            return this.posixUser((PosixUser)((PosixUser.Builder)PosixUser.builder().applyMutation(posixUser)).build());
        }

        public Builder rootDirectory(RootDirectory var1);

        default public Builder rootDirectory(Consumer<RootDirectory.Builder> rootDirectory) {
            return this.rootDirectory((RootDirectory)((RootDirectory.Builder)RootDirectory.builder().applyMutation(rootDirectory)).build());
        }

        public Builder ownerId(String var1);

        public Builder lifeCycleState(String var1);

        public Builder lifeCycleState(LifeCycleState var1);
    }
}

