/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.services.efs.model.ReplicationOverwriteProtection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFileSystemProtectionRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, UpdateFileSystemProtectionRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(UpdateFileSystemProtectionRequest.getter(UpdateFileSystemProtectionRequest::fileSystemId)).setter(UpdateFileSystemProtectionRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> REPLICATION_OVERWRITE_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationOverwriteProtection").getter(UpdateFileSystemProtectionRequest.getter(UpdateFileSystemProtectionRequest::replicationOverwriteProtectionAsString)).setter(UpdateFileSystemProtectionRequest.setter(Builder::replicationOverwriteProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationOverwriteProtection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, REPLICATION_OVERWRITE_PROTECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFileSystemProtectionRequest.memberNameToFieldInitializer();
    private final String fileSystemId;
    private final String replicationOverwriteProtection;

    private UpdateFileSystemProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.replicationOverwriteProtection = builder.replicationOverwriteProtection;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final ReplicationOverwriteProtection replicationOverwriteProtection() {
        return ReplicationOverwriteProtection.fromValue(this.replicationOverwriteProtection);
    }

    public final String replicationOverwriteProtectionAsString() {
        return this.replicationOverwriteProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationOverwriteProtectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemProtectionRequest)) {
            return false;
        }
        UpdateFileSystemProtectionRequest other = (UpdateFileSystemProtectionRequest)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.replicationOverwriteProtectionAsString(), other.replicationOverwriteProtectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFileSystemProtectionRequest").add("FileSystemId", (Object)this.fileSystemId()).add("ReplicationOverwriteProtection", (Object)this.replicationOverwriteProtectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "ReplicationOverwriteProtection": {
                return Optional.ofNullable(clazz.cast(this.replicationOverwriteProtectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("ReplicationOverwriteProtection", REPLICATION_OVERWRITE_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemProtectionRequest, T> g) {
        return obj -> g.apply((UpdateFileSystemProtectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String replicationOverwriteProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemProtectionRequest model) {
            super(model);
            this.fileSystemId(model.fileSystemId);
            this.replicationOverwriteProtection(model.replicationOverwriteProtection);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getReplicationOverwriteProtection() {
            return this.replicationOverwriteProtection;
        }

        public final void setReplicationOverwriteProtection(String replicationOverwriteProtection) {
            this.replicationOverwriteProtection = replicationOverwriteProtection;
        }

        @Override
        public final Builder replicationOverwriteProtection(String replicationOverwriteProtection) {
            this.replicationOverwriteProtection = replicationOverwriteProtection;
            return this;
        }

        @Override
        public final Builder replicationOverwriteProtection(ReplicationOverwriteProtection replicationOverwriteProtection) {
            this.replicationOverwriteProtection(replicationOverwriteProtection == null ? null : replicationOverwriteProtection.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFileSystemProtectionRequest build() {
            return new UpdateFileSystemProtectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFileSystemProtectionRequest> {
        public Builder fileSystemId(String var1);

        public Builder replicationOverwriteProtection(String var1);

        public Builder replicationOverwriteProtection(ReplicationOverwriteProtection var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

