/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PerformanceMode {
    GENERAL_PURPOSE("generalPurpose"),
    MAX_IO("maxIO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PerformanceMode> VALUE_MAP;
    private final String value;

    private PerformanceMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PerformanceMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PerformanceMode> knownValues() {
        EnumSet<PerformanceMode> knownValues = EnumSet.allOf(PerformanceMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PerformanceMode.class, PerformanceMode::toString);
    }
}

