/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Resource {
    FILE_SYSTEM("FILE_SYSTEM"),
    MOUNT_TARGET("MOUNT_TARGET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Resource> VALUE_MAP;
    private final String value;

    private Resource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Resource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Resource> knownValues() {
        EnumSet<Resource> knownValues = EnumSet.allOf(Resource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Resource.class, Resource::toString);
    }
}

