/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.efs.DefaultEfsBaseClientBuilder;
import software.amazon.awssdk.services.efs.DefaultEfsClient;
import software.amazon.awssdk.services.efs.EfsClient;
import software.amazon.awssdk.services.efs.EfsClientBuilder;
import software.amazon.awssdk.services.efs.EfsServiceClientConfiguration;
import software.amazon.awssdk.services.efs.endpoints.EfsEndpointProvider;

@SdkInternalApi
final class DefaultEfsClientBuilder
extends DefaultEfsBaseClientBuilder<EfsClientBuilder, EfsClient>
implements EfsClientBuilder {
    DefaultEfsClientBuilder() {
    }

    @Override
    public DefaultEfsClientBuilder endpointProvider(EfsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EfsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEfsClientBuilder.validateClientOptions(clientConfiguration);
        EfsServiceClientConfiguration serviceClientConfiguration = EfsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultEfsClient(serviceClientConfiguration, clientConfiguration);
    }
}

