/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFileSystemPolicyResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, DescribeFileSystemPolicyResponse> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(DescribeFileSystemPolicyResponse.getter(DescribeFileSystemPolicyResponse::fileSystemId)).setter(DescribeFileSystemPolicyResponse.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(DescribeFileSystemPolicyResponse.getter(DescribeFileSystemPolicyResponse::policy)).setter(DescribeFileSystemPolicyResponse.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, POLICY_FIELD));
    private final String fileSystemId;
    private final String policy;

    private DescribeFileSystemPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.policy = builder.policy;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String policy() {
        return this.policy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemPolicyResponse)) {
            return false;
        }
        DescribeFileSystemPolicyResponse other = (DescribeFileSystemPolicyResponse)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.policy(), other.policy());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFileSystemPolicyResponse").add("FileSystemId", (Object)this.fileSystemId()).add("Policy", (Object)this.policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemPolicyResponse, T> g) {
        return obj -> g.apply((DescribeFileSystemPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemPolicyResponse model) {
            super(model);
            this.fileSystemId(model.fileSystemId);
            this.policy(model.policy);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public DescribeFileSystemPolicyResponse build() {
            return new DescribeFileSystemPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFileSystemPolicyResponse> {
        public Builder fileSystemId(String var1);

        public Builder policy(String var1);
    }
}

