/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.BackupPolicy;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutBackupPolicyRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, PutBackupPolicyRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(PutBackupPolicyRequest.getter(PutBackupPolicyRequest::fileSystemId)).setter(PutBackupPolicyRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileSystemId").build()}).build();
    private static final SdkField<BackupPolicy> BACKUP_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackupPolicy").getter(PutBackupPolicyRequest.getter(PutBackupPolicyRequest::backupPolicy)).setter(PutBackupPolicyRequest.setter(Builder::backupPolicy)).constructor(BackupPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, BACKUP_POLICY_FIELD));
    private final String fileSystemId;
    private final BackupPolicy backupPolicy;

    private PutBackupPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.backupPolicy = builder.backupPolicy;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final BackupPolicy backupPolicy() {
        return this.backupPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBackupPolicyRequest)) {
            return false;
        }
        PutBackupPolicyRequest other = (PutBackupPolicyRequest)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.backupPolicy(), other.backupPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutBackupPolicyRequest").add("FileSystemId", (Object)this.fileSystemId()).add("BackupPolicy", (Object)this.backupPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "BackupPolicy": {
                return Optional.ofNullable(clazz.cast(this.backupPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBackupPolicyRequest, T> g) {
        return obj -> g.apply((PutBackupPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private String fileSystemId;
        private BackupPolicy backupPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBackupPolicyRequest model) {
            super(model);
            this.fileSystemId(model.fileSystemId);
            this.backupPolicy(model.backupPolicy);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final BackupPolicy.Builder getBackupPolicy() {
            return this.backupPolicy != null ? this.backupPolicy.toBuilder() : null;
        }

        @Override
        public final Builder backupPolicy(BackupPolicy backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        public final void setBackupPolicy(BackupPolicy.BuilderImpl backupPolicy) {
            this.backupPolicy = backupPolicy != null ? backupPolicy.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBackupPolicyRequest build() {
            return new PutBackupPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutBackupPolicyRequest> {
        public Builder fileSystemId(String var1);

        public Builder backupPolicy(BackupPolicy var1);

        default public Builder backupPolicy(Consumer<BackupPolicy.Builder> backupPolicy) {
            return this.backupPolicy((BackupPolicy)((BackupPolicy.Builder)BackupPolicy.builder().applyMutation(backupPolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

