/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.services.efs.model.MountTargetDescription;
import software.amazon.awssdk.services.efs.model.MountTargetDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMountTargetsResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, DescribeMountTargetsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeMountTargetsResponse.getter(DescribeMountTargetsResponse::marker)).setter(DescribeMountTargetsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<MountTargetDescription>> MOUNT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MountTargets").getter(DescribeMountTargetsResponse.getter(DescribeMountTargetsResponse::mountTargets)).setter(DescribeMountTargetsResponse.setter(Builder::mountTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MountTargetDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(DescribeMountTargetsResponse.getter(DescribeMountTargetsResponse::nextMarker)).setter(DescribeMountTargetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MOUNT_TARGETS_FIELD, NEXT_MARKER_FIELD));
    private final String marker;
    private final List<MountTargetDescription> mountTargets;
    private final String nextMarker;

    private DescribeMountTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.mountTargets = builder.mountTargets;
        this.nextMarker = builder.nextMarker;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasMountTargets() {
        return this.mountTargets != null && !(this.mountTargets instanceof SdkAutoConstructList);
    }

    public final List<MountTargetDescription> mountTargets() {
        return this.mountTargets;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMountTargets() ? this.mountTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsResponse)) {
            return false;
        }
        DescribeMountTargetsResponse other = (DescribeMountTargetsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasMountTargets() == other.hasMountTargets() && Objects.equals(this.mountTargets(), other.mountTargets()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMountTargetsResponse").add("Marker", (Object)this.marker()).add("MountTargets", this.hasMountTargets() ? this.mountTargets() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MountTargets": {
                return Optional.ofNullable(clazz.cast(this.mountTargets()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMountTargetsResponse, T> g) {
        return obj -> g.apply((DescribeMountTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<MountTargetDescription> mountTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsResponse model) {
            super(model);
            this.marker(model.marker);
            this.mountTargets(model.mountTargets);
            this.nextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<MountTargetDescription.Builder> getMountTargets() {
            if (this.mountTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mountTargets != null ? (Collection)this.mountTargets.stream().map(MountTargetDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mountTargets(Collection<MountTargetDescription> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copy(mountTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountTargets(MountTargetDescription ... mountTargets) {
            this.mountTargets(Arrays.asList(mountTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountTargets(Consumer<MountTargetDescription.Builder> ... mountTargets) {
            this.mountTargets(Stream.of(mountTargets).map(c -> (MountTargetDescription)((MountTargetDescription.Builder)MountTargetDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMountTargets(Collection<MountTargetDescription.BuilderImpl> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copyFromBuilder(mountTargets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeMountTargetsResponse build() {
            return new DescribeMountTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMountTargetsResponse> {
        public Builder marker(String var1);

        public Builder mountTargets(Collection<MountTargetDescription> var1);

        public Builder mountTargets(MountTargetDescription ... var1);

        public Builder mountTargets(Consumer<MountTargetDescription.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

