/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.SecondaryGidsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PosixUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PosixUser> {
    private static final SdkField<Long> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Uid").getter(PosixUser.getter(PosixUser::uid)).setter(PosixUser.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uid").build()}).build();
    private static final SdkField<Long> GID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Gid").getter(PosixUser.getter(PosixUser::gid)).setter(PosixUser.setter(Builder::gid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gid").build()}).build();
    private static final SdkField<List<Long>> SECONDARY_GIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecondaryGids").getter(PosixUser.getter(PosixUser::secondaryGids)).setter(PosixUser.setter(Builder::secondaryGids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryGids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, GID_FIELD, SECONDARY_GIDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long uid;
    private final Long gid;
    private final List<Long> secondaryGids;

    private PosixUser(BuilderImpl builder) {
        this.uid = builder.uid;
        this.gid = builder.gid;
        this.secondaryGids = builder.secondaryGids;
    }

    public Long uid() {
        return this.uid;
    }

    public Long gid() {
        return this.gid;
    }

    public boolean hasSecondaryGids() {
        return this.secondaryGids != null && !(this.secondaryGids instanceof SdkAutoConstructList);
    }

    public List<Long> secondaryGids() {
        return this.secondaryGids;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        hashCode = 31 * hashCode + Objects.hashCode(this.gid());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryGids());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PosixUser)) {
            return false;
        }
        PosixUser other = (PosixUser)obj;
        return Objects.equals(this.uid(), other.uid()) && Objects.equals(this.gid(), other.gid()) && Objects.equals(this.secondaryGids(), other.secondaryGids());
    }

    public String toString() {
        return ToString.builder((String)"PosixUser").add("Uid", (Object)this.uid()).add("Gid", (Object)this.gid()).add("SecondaryGids", this.secondaryGids()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
            case "Gid": {
                return Optional.ofNullable(clazz.cast(this.gid()));
            }
            case "SecondaryGids": {
                return Optional.ofNullable(clazz.cast(this.secondaryGids()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PosixUser, T> g) {
        return obj -> g.apply((PosixUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long uid;
        private Long gid;
        private List<Long> secondaryGids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PosixUser model) {
            this.uid(model.uid);
            this.gid(model.gid);
            this.secondaryGids(model.secondaryGids);
        }

        public final Long getUid() {
            return this.uid;
        }

        @Override
        public final Builder uid(Long uid) {
            this.uid = uid;
            return this;
        }

        public final void setUid(Long uid) {
            this.uid = uid;
        }

        public final Long getGid() {
            return this.gid;
        }

        @Override
        public final Builder gid(Long gid) {
            this.gid = gid;
            return this;
        }

        public final void setGid(Long gid) {
            this.gid = gid;
        }

        public final Collection<Long> getSecondaryGids() {
            return this.secondaryGids;
        }

        @Override
        public final Builder secondaryGids(Collection<Long> secondaryGids) {
            this.secondaryGids = SecondaryGidsCopier.copy(secondaryGids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryGids(Long ... secondaryGids) {
            this.secondaryGids(Arrays.asList(secondaryGids));
            return this;
        }

        public final void setSecondaryGids(Collection<Long> secondaryGids) {
            this.secondaryGids = SecondaryGidsCopier.copy(secondaryGids);
        }

        public PosixUser build() {
            return new PosixUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PosixUser> {
        public Builder uid(Long var1);

        public Builder gid(Long var1);

        public Builder secondaryGids(Collection<Long> var1);

        public Builder secondaryGids(Long ... var1);
    }
}

