/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.services.efs.model.EfsResponseMetadata;

public abstract class EfsResponse
extends AwsResponse {
    private final EfsResponseMetadata responseMetadata;

    protected EfsResponse(Builder builder) {
        super((AwsResponse.Builder)builder);
        this.responseMetadata = builder.responseMetadata();
    }

    public EfsResponseMetadata responseMetadata() {
        return this.responseMetadata;
    }

    protected static abstract class BuilderImpl
    extends AwsResponse.BuilderImpl
    implements Builder {
        private EfsResponseMetadata responseMetadata;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EfsResponse response) {
            super((AwsResponse)response);
            this.responseMetadata = response.responseMetadata();
        }

        @Override
        public EfsResponseMetadata responseMetadata() {
            return this.responseMetadata;
        }

        @Override
        public Builder responseMetadata(AwsResponseMetadata responseMetadata) {
            this.responseMetadata = EfsResponseMetadata.create(responseMetadata);
            return this;
        }
    }

    public static interface Builder
    extends AwsResponse.Builder {
        public EfsResponse build();

        public EfsResponseMetadata responseMetadata();

        public Builder responseMetadata(AwsResponseMetadata var1);
    }
}

