/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.MountTargetDescription;

@SdkInternalApi
public class MountTargetDescriptionMarshaller {
    private static final MarshallingInfo<String> OWNERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerId").build();
    private static final MarshallingInfo<String> MOUNTTARGETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MountTargetId").build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").build();
    private static final MarshallingInfo<String> LIFECYCLESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifeCycleState").build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").build();
    private static final MarshallingInfo<String> NETWORKINTERFACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetworkInterfaceId").build();
    private static final MountTargetDescriptionMarshaller instance = new MountTargetDescriptionMarshaller();

    public static MountTargetDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(MountTargetDescription mountTargetDescription, ProtocolMarshaller protocolMarshaller) {
        if (mountTargetDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mountTargetDescription.ownerId(), OWNERID_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.mountTargetId(), MOUNTTARGETID_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.fileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.lifeCycleState(), LIFECYCLESTATE_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.networkInterfaceId(), NETWORKINTERFACEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

