/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.CapacityReservationPreference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservationRequest> {
    private static final SdkField<String> RESERVATION_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reservationGroupArn").getter(CapacityReservationRequest.getter(CapacityReservationRequest::reservationGroupArn)).setter(CapacityReservationRequest.setter(Builder::reservationGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationGroupArn").build()}).build();
    private static final SdkField<String> RESERVATION_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reservationPreference").getter(CapacityReservationRequest.getter(CapacityReservationRequest::reservationPreferenceAsString)).setter(CapacityReservationRequest.setter(Builder::reservationPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationPreference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_GROUP_ARN_FIELD, RESERVATION_PREFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityReservationRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reservationGroupArn;
    private final String reservationPreference;

    private CapacityReservationRequest(BuilderImpl builder) {
        this.reservationGroupArn = builder.reservationGroupArn;
        this.reservationPreference = builder.reservationPreference;
    }

    public final String reservationGroupArn() {
        return this.reservationGroupArn;
    }

    public final CapacityReservationPreference reservationPreference() {
        return CapacityReservationPreference.fromValue(this.reservationPreference);
    }

    public final String reservationPreferenceAsString() {
        return this.reservationPreference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationPreferenceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationRequest)) {
            return false;
        }
        CapacityReservationRequest other = (CapacityReservationRequest)obj;
        return Objects.equals(this.reservationGroupArn(), other.reservationGroupArn()) && Objects.equals(this.reservationPreferenceAsString(), other.reservationPreferenceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityReservationRequest").add("ReservationGroupArn", (Object)this.reservationGroupArn()).add("ReservationPreference", (Object)this.reservationPreferenceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reservationGroupArn": {
                return Optional.ofNullable(clazz.cast(this.reservationGroupArn()));
            }
            case "reservationPreference": {
                return Optional.ofNullable(clazz.cast(this.reservationPreferenceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("reservationGroupArn", RESERVATION_GROUP_ARN_FIELD);
        map.put("reservationPreference", RESERVATION_PREFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationRequest, T> g) {
        return obj -> g.apply((CapacityReservationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservationGroupArn;
        private String reservationPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationRequest model) {
            this.reservationGroupArn(model.reservationGroupArn);
            this.reservationPreference(model.reservationPreference);
        }

        public final String getReservationGroupArn() {
            return this.reservationGroupArn;
        }

        public final void setReservationGroupArn(String reservationGroupArn) {
            this.reservationGroupArn = reservationGroupArn;
        }

        @Override
        public final Builder reservationGroupArn(String reservationGroupArn) {
            this.reservationGroupArn = reservationGroupArn;
            return this;
        }

        public final String getReservationPreference() {
            return this.reservationPreference;
        }

        public final void setReservationPreference(String reservationPreference) {
            this.reservationPreference = reservationPreference;
        }

        @Override
        public final Builder reservationPreference(String reservationPreference) {
            this.reservationPreference = reservationPreference;
            return this;
        }

        @Override
        public final Builder reservationPreference(CapacityReservationPreference reservationPreference) {
            this.reservationPreference(reservationPreference == null ? null : reservationPreference.toString());
            return this;
        }

        public CapacityReservationRequest build() {
            return new CapacityReservationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservationRequest> {
        public Builder reservationGroupArn(String var1);

        public Builder reservationPreference(String var1);

        public Builder reservationPreference(CapacityReservationPreference var1);
    }
}

