/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CapacityOptionType {
    ON_DEMAND("ON_DEMAND"),
    SPOT("SPOT"),
    RESERVED("RESERVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapacityOptionType> VALUE_MAP;
    private final String value;

    private CapacityOptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CapacityOptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CapacityOptionType> knownValues() {
        EnumSet<CapacityOptionType> knownValues = EnumSet.allOf(CapacityOptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CapacityOptionType.class, CapacityOptionType::toString);
    }
}

