/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.waiters;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.ecs.model.DescribeServicesRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServicesResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTasksRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTasksResponse;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.waiters.EcsWaiter;
import software.amazon.awssdk.services.ecs.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultEcsWaiter
implements EcsWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final EcsClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeServicesResponse> servicesInactiveWaiter;
    private final Waiter<DescribeServicesResponse> servicesStableWaiter;
    private final Waiter<DescribeTasksResponse> tasksRunningWaiter;
    private final Waiter<DescribeTasksResponse> tasksStoppedWaiter;

    private DefaultEcsWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (EcsClient)EcsClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.servicesInactiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeServicesResponse.class).acceptors(DefaultEcsWaiter.servicesInactiveWaiterAcceptors())).overrideConfiguration(DefaultEcsWaiter.servicesInactiveWaiterConfig(builder.overrideConfiguration))).build();
        this.servicesStableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeServicesResponse.class).acceptors(DefaultEcsWaiter.servicesStableWaiterAcceptors())).overrideConfiguration(DefaultEcsWaiter.servicesStableWaiterConfig(builder.overrideConfiguration))).build();
        this.tasksRunningWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTasksResponse.class).acceptors(DefaultEcsWaiter.tasksRunningWaiterAcceptors())).overrideConfiguration(DefaultEcsWaiter.tasksRunningWaiterConfig(builder.overrideConfiguration))).build();
        this.tasksStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTasksResponse.class).acceptors(DefaultEcsWaiter.tasksStoppedWaiterAcceptors())).overrideConfiguration(DefaultEcsWaiter.tasksStoppedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeServicesResponse> waitUntilServicesInactive(DescribeServicesRequest describeServicesRequest) {
        return this.servicesInactiveWaiter.run(() -> this.client.describeServices(this.applyWaitersUserAgent(describeServicesRequest)));
    }

    @Override
    public WaiterResponse<DescribeServicesResponse> waitUntilServicesInactive(DescribeServicesRequest describeServicesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.servicesInactiveWaiter.run(() -> this.client.describeServices(this.applyWaitersUserAgent(describeServicesRequest)), DefaultEcsWaiter.servicesInactiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeServicesResponse> waitUntilServicesStable(DescribeServicesRequest describeServicesRequest) {
        return this.servicesStableWaiter.run(() -> this.client.describeServices(this.applyWaitersUserAgent(describeServicesRequest)));
    }

    @Override
    public WaiterResponse<DescribeServicesResponse> waitUntilServicesStable(DescribeServicesRequest describeServicesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.servicesStableWaiter.run(() -> this.client.describeServices(this.applyWaitersUserAgent(describeServicesRequest)), DefaultEcsWaiter.servicesStableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTasksResponse> waitUntilTasksRunning(DescribeTasksRequest describeTasksRequest) {
        return this.tasksRunningWaiter.run(() -> this.client.describeTasks(this.applyWaitersUserAgent(describeTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeTasksResponse> waitUntilTasksRunning(DescribeTasksRequest describeTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.tasksRunningWaiter.run(() -> this.client.describeTasks(this.applyWaitersUserAgent(describeTasksRequest)), DefaultEcsWaiter.tasksRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTasksResponse> waitUntilTasksStopped(DescribeTasksRequest describeTasksRequest) {
        return this.tasksStoppedWaiter.run(() -> this.client.describeTasks(this.applyWaitersUserAgent(describeTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeTasksResponse> waitUntilTasksStopped(DescribeTasksRequest describeTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.tasksStoppedWaiter.run(() -> this.client.describeTasks(this.applyWaitersUserAgent(describeTasksRequest)), DefaultEcsWaiter.tasksStoppedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeServicesResponse>> servicesInactiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeServicesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeServicesResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("failures").flatten().field("reason").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "MISSING"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (failures[].reason=MISSING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("services").flatten().field("status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "INACTIVE"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeServicesResponse>> servicesStableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeServicesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeServicesResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("failures").flatten().field("reason").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "MISSING"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (failures[].reason=MISSING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("services").flatten().field("status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "DRAINING"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (services[].status=DRAINING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("services").flatten().field("status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "INACTIVE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (services[].status=INACTIVE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("services").filter(x0 -> x0.constant(x0.field("deployments").length().compare("==", x0.constant(new BigDecimal("1"))).and(x0.field("runningCount").compare("==", x0.field("desiredCount"))).not())).length().compare("==", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTasksResponse>> tasksRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTasksResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("tasks").flatten().field("lastStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "STOPPED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (tasks[].lastStatus=STOPPED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("failures").flatten().field("reason").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "MISSING"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (failures[].reason=MISSING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("tasks").flatten().field("lastStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "RUNNING"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTasksResponse>> tasksStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("tasks").flatten().field("lastStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "STOPPED"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration servicesInactiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration servicesStableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration tasksRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(100);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(6L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration tasksStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(100);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(6L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static EcsWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends EcsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EcsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements EcsWaiter.Builder {
        private EcsClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public EcsWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public EcsWaiter.Builder client(EcsClient client) {
            this.client = client;
            return this;
        }

        @Override
        public EcsWaiter build() {
            return new DefaultEcsWaiter(this);
        }
    }
}

