/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse;

public class ListContainerInstancesPublisher
implements SdkPublisher<ListContainerInstancesResponse> {
    private final EcsAsyncClient client;
    private final ListContainerInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContainerInstancesPublisher(EcsAsyncClient client, ListContainerInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContainerInstancesPublisher(EcsAsyncClient client, ListContainerInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContainerInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContainerInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> containerInstanceArns() {
        return this.flatMapIterable(response -> response.containerInstanceArns());
    }

    private class ListContainerInstancesResponseFetcher
    implements AsyncPageFetcher<ListContainerInstancesResponse> {
        private ListContainerInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContainerInstancesResponse> nextPage(ListContainerInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListContainerInstancesPublisher.this.client.listContainerInstances(ListContainerInstancesPublisher.this.firstRequest);
            }
            return ListContainerInstancesPublisher.this.client.listContainerInstances((ListContainerInstancesRequest)((Object)ListContainerInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

