/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes an Express service to be updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatedExpressGatewayService implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdatedExpressGatewayService.Builder, UpdatedExpressGatewayService> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceArn").getter(getter(UpdatedExpressGatewayService::serviceArn))
            .setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()).build();

    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(UpdatedExpressGatewayService::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(UpdatedExpressGatewayService::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<ExpressGatewayServiceStatus> STATUS_FIELD = SdkField
            .<ExpressGatewayServiceStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(UpdatedExpressGatewayService::status)).setter(setter(Builder::status))
            .constructor(ExpressGatewayServiceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ExpressGatewayServiceConfiguration> TARGET_CONFIGURATION_FIELD = SdkField
            .<ExpressGatewayServiceConfiguration> builder(MarshallingType.SDK_POJO).memberName("targetConfiguration")
            .getter(getter(UpdatedExpressGatewayService::targetConfiguration)).setter(setter(Builder::targetConfiguration))
            .constructor(ExpressGatewayServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(UpdatedExpressGatewayService::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(UpdatedExpressGatewayService::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD,
            CLUSTER_FIELD, SERVICE_NAME_FIELD, STATUS_FIELD, TARGET_CONFIGURATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceArn;

    private final String cluster;

    private final String serviceName;

    private final ExpressGatewayServiceStatus status;

    private final ExpressGatewayServiceConfiguration targetConfiguration;

    private final Instant createdAt;

    private final Instant updatedAt;

    private UpdatedExpressGatewayService(BuilderImpl builder) {
        this.serviceArn = builder.serviceArn;
        this.cluster = builder.cluster;
        this.serviceName = builder.serviceName;
        this.status = builder.status;
        this.targetConfiguration = builder.targetConfiguration;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ARN of the Express service that is being updated.
     * </p>
     * 
     * @return The ARN of the Express service that is being updated.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * The cluster associated with the Express service that is being updated.
     * </p>
     * 
     * @return The cluster associated with the Express service that is being updated.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The name of the Express service that is being updated.
     * </p>
     * 
     * @return The name of the Express service that is being updated.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The status of the Express service that is being updated.
     * </p>
     * 
     * @return The status of the Express service that is being updated.
     */
    public final ExpressGatewayServiceStatus status() {
        return status;
    }

    /**
     * <p>
     * The configuration to which the current Express service is being updated to.
     * </p>
     * 
     * @return The configuration to which the current Express service is being updated to.
     */
    public final ExpressGatewayServiceConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    /**
     * <p>
     * The Unix timestamp for when the Express service that is being updated was created.
     * </p>
     * 
     * @return The Unix timestamp for when the Express service that is being updated was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp for when the Express service that is being updated was most recently updated.
     * </p>
     * 
     * @return The Unix timestamp for when the Express service that is being updated was most recently updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatedExpressGatewayService)) {
            return false;
        }
        UpdatedExpressGatewayService other = (UpdatedExpressGatewayService) obj;
        return Objects.equals(serviceArn(), other.serviceArn()) && Objects.equals(cluster(), other.cluster())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(status(), other.status())
                && Objects.equals(targetConfiguration(), other.targetConfiguration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatedExpressGatewayService").add("ServiceArn", serviceArn()).add("Cluster", cluster())
                .add("ServiceName", serviceName()).add("Status", status()).add("TargetConfiguration", targetConfiguration())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "targetConfiguration":
            return Optional.ofNullable(clazz.cast(targetConfiguration()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("cluster", CLUSTER_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("targetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatedExpressGatewayService, T> g) {
        return obj -> g.apply((UpdatedExpressGatewayService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdatedExpressGatewayService> {
        /**
         * <p>
         * The ARN of the Express service that is being updated.
         * </p>
         * 
         * @param serviceArn
         *        The ARN of the Express service that is being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * The cluster associated with the Express service that is being updated.
         * </p>
         * 
         * @param cluster
         *        The cluster associated with the Express service that is being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The name of the Express service that is being updated.
         * </p>
         * 
         * @param serviceName
         *        The name of the Express service that is being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The status of the Express service that is being updated.
         * </p>
         * 
         * @param status
         *        The status of the Express service that is being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ExpressGatewayServiceStatus status);

        /**
         * <p>
         * The status of the Express service that is being updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressGatewayServiceStatus.Builder}
         * avoiding the need to create one manually via {@link ExpressGatewayServiceStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayServiceStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(ExpressGatewayServiceStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ExpressGatewayServiceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ExpressGatewayServiceStatus)
         */
        default Builder status(Consumer<ExpressGatewayServiceStatus.Builder> status) {
            return status(ExpressGatewayServiceStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The configuration to which the current Express service is being updated to.
         * </p>
         * 
         * @param targetConfiguration
         *        The configuration to which the current Express service is being updated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(ExpressGatewayServiceConfiguration targetConfiguration);

        /**
         * <p>
         * The configuration to which the current Express service is being updated to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExpressGatewayServiceConfiguration.Builder} avoiding the need to create one manually via
         * {@link ExpressGatewayServiceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #targetConfiguration(ExpressGatewayServiceConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link ExpressGatewayServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(ExpressGatewayServiceConfiguration)
         */
        default Builder targetConfiguration(Consumer<ExpressGatewayServiceConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(ExpressGatewayServiceConfiguration.builder().applyMutation(targetConfiguration).build());
        }

        /**
         * <p>
         * The Unix timestamp for when the Express service that is being updated was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp for when the Express service that is being updated was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp for when the Express service that is being updated was most recently updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp for when the Express service that is being updated was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String serviceArn;

        private String cluster;

        private String serviceName;

        private ExpressGatewayServiceStatus status;

        private ExpressGatewayServiceConfiguration targetConfiguration;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatedExpressGatewayService model) {
            serviceArn(model.serviceArn);
            cluster(model.cluster);
            serviceName(model.serviceName);
            status(model.status);
            targetConfiguration(model.targetConfiguration);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final ExpressGatewayServiceStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ExpressGatewayServiceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ExpressGatewayServiceStatus status) {
            this.status = status;
            return this;
        }

        public final ExpressGatewayServiceConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(ExpressGatewayServiceConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(ExpressGatewayServiceConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public UpdatedExpressGatewayService build() {
            return new UpdatedExpressGatewayService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
