/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for Service Connect access logging. Access logs provide detailed information about requests made to
 * your service, including request patterns, response codes, and timing data for debugging and monitoring purposes.
 * </p>
 * <note>
 * <p>
 * To enable access logs, you must also specify a <code>logConfiguration</code> in the
 * <code>serviceConnectConfiguration</code>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceConnectAccessLogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceConnectAccessLogConfiguration.Builder, ServiceConnectAccessLogConfiguration> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(ServiceConnectAccessLogConfiguration::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> INCLUDE_QUERY_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("includeQueryParameters")
            .getter(getter(ServiceConnectAccessLogConfiguration::includeQueryParametersAsString))
            .setter(setter(Builder::includeQueryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeQueryParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            INCLUDE_QUERY_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String includeQueryParameters;

    private ServiceConnectAccessLogConfiguration(BuilderImpl builder) {
        this.format = builder.format;
        this.includeQueryParameters = builder.includeQueryParameters;
    }

    /**
     * <p>
     * The format for Service Connect access log output. Choose TEXT for human-readable logs or JSON for structured data
     * that integrates well with log analysis tools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ServiceConnectAccessLoggingFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #formatAsString}.
     * </p>
     * 
     * @return The format for Service Connect access log output. Choose TEXT for human-readable logs or JSON for
     *         structured data that integrates well with log analysis tools.
     * @see ServiceConnectAccessLoggingFormat
     */
    public final ServiceConnectAccessLoggingFormat format() {
        return ServiceConnectAccessLoggingFormat.fromValue(format);
    }

    /**
     * <p>
     * The format for Service Connect access log output. Choose TEXT for human-readable logs or JSON for structured data
     * that integrates well with log analysis tools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ServiceConnectAccessLoggingFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #formatAsString}.
     * </p>
     * 
     * @return The format for Service Connect access log output. Choose TEXT for human-readable logs or JSON for
     *         structured data that integrates well with log analysis tools.
     * @see ServiceConnectAccessLoggingFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * Specifies whether to include query parameters in Service Connect access logs.
     * </p>
     * <p>
     * When enabled, query parameters from HTTP requests are included in the access logs. Consider security and privacy
     * implications when enabling this feature, as query parameters may contain sensitive information such as request
     * IDs and tokens. By default, this parameter is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeQueryParameters} will return {@link ServiceConnectIncludeQueryParameters#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #includeQueryParametersAsString}.
     * </p>
     * 
     * @return Specifies whether to include query parameters in Service Connect access logs.</p>
     *         <p>
     *         When enabled, query parameters from HTTP requests are included in the access logs. Consider security and
     *         privacy implications when enabling this feature, as query parameters may contain sensitive information
     *         such as request IDs and tokens. By default, this parameter is <code>DISABLED</code>.
     * @see ServiceConnectIncludeQueryParameters
     */
    public final ServiceConnectIncludeQueryParameters includeQueryParameters() {
        return ServiceConnectIncludeQueryParameters.fromValue(includeQueryParameters);
    }

    /**
     * <p>
     * Specifies whether to include query parameters in Service Connect access logs.
     * </p>
     * <p>
     * When enabled, query parameters from HTTP requests are included in the access logs. Consider security and privacy
     * implications when enabling this feature, as query parameters may contain sensitive information such as request
     * IDs and tokens. By default, this parameter is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeQueryParameters} will return {@link ServiceConnectIncludeQueryParameters#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #includeQueryParametersAsString}.
     * </p>
     * 
     * @return Specifies whether to include query parameters in Service Connect access logs.</p>
     *         <p>
     *         When enabled, query parameters from HTTP requests are included in the access logs. Consider security and
     *         privacy implications when enabling this feature, as query parameters may contain sensitive information
     *         such as request IDs and tokens. By default, this parameter is <code>DISABLED</code>.
     * @see ServiceConnectIncludeQueryParameters
     */
    public final String includeQueryParametersAsString() {
        return includeQueryParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeQueryParametersAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectAccessLogConfiguration)) {
            return false;
        }
        ServiceConnectAccessLogConfiguration other = (ServiceConnectAccessLogConfiguration) obj;
        return Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(includeQueryParametersAsString(), other.includeQueryParametersAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceConnectAccessLogConfiguration").add("Format", formatAsString())
                .add("IncludeQueryParameters", includeQueryParametersAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "includeQueryParameters":
            return Optional.ofNullable(clazz.cast(includeQueryParametersAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("format", FORMAT_FIELD);
        map.put("includeQueryParameters", INCLUDE_QUERY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectAccessLogConfiguration, T> g) {
        return obj -> g.apply((ServiceConnectAccessLogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceConnectAccessLogConfiguration> {
        /**
         * <p>
         * The format for Service Connect access log output. Choose TEXT for human-readable logs or JSON for structured
         * data that integrates well with log analysis tools.
         * </p>
         * 
         * @param format
         *        The format for Service Connect access log output. Choose TEXT for human-readable logs or JSON for
         *        structured data that integrates well with log analysis tools.
         * @see ServiceConnectAccessLoggingFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceConnectAccessLoggingFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format for Service Connect access log output. Choose TEXT for human-readable logs or JSON for structured
         * data that integrates well with log analysis tools.
         * </p>
         * 
         * @param format
         *        The format for Service Connect access log output. Choose TEXT for human-readable logs or JSON for
         *        structured data that integrates well with log analysis tools.
         * @see ServiceConnectAccessLoggingFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceConnectAccessLoggingFormat
         */
        Builder format(ServiceConnectAccessLoggingFormat format);

        /**
         * <p>
         * Specifies whether to include query parameters in Service Connect access logs.
         * </p>
         * <p>
         * When enabled, query parameters from HTTP requests are included in the access logs. Consider security and
         * privacy implications when enabling this feature, as query parameters may contain sensitive information such
         * as request IDs and tokens. By default, this parameter is <code>DISABLED</code>.
         * </p>
         * 
         * @param includeQueryParameters
         *        Specifies whether to include query parameters in Service Connect access logs.</p>
         *        <p>
         *        When enabled, query parameters from HTTP requests are included in the access logs. Consider security
         *        and privacy implications when enabling this feature, as query parameters may contain sensitive
         *        information such as request IDs and tokens. By default, this parameter is <code>DISABLED</code>.
         * @see ServiceConnectIncludeQueryParameters
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceConnectIncludeQueryParameters
         */
        Builder includeQueryParameters(String includeQueryParameters);

        /**
         * <p>
         * Specifies whether to include query parameters in Service Connect access logs.
         * </p>
         * <p>
         * When enabled, query parameters from HTTP requests are included in the access logs. Consider security and
         * privacy implications when enabling this feature, as query parameters may contain sensitive information such
         * as request IDs and tokens. By default, this parameter is <code>DISABLED</code>.
         * </p>
         * 
         * @param includeQueryParameters
         *        Specifies whether to include query parameters in Service Connect access logs.</p>
         *        <p>
         *        When enabled, query parameters from HTTP requests are included in the access logs. Consider security
         *        and privacy implications when enabling this feature, as query parameters may contain sensitive
         *        information such as request IDs and tokens. By default, this parameter is <code>DISABLED</code>.
         * @see ServiceConnectIncludeQueryParameters
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceConnectIncludeQueryParameters
         */
        Builder includeQueryParameters(ServiceConnectIncludeQueryParameters includeQueryParameters);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String includeQueryParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectAccessLogConfiguration model) {
            format(model.format);
            includeQueryParameters(model.includeQueryParameters);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ServiceConnectAccessLoggingFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getIncludeQueryParameters() {
            return includeQueryParameters;
        }

        public final void setIncludeQueryParameters(String includeQueryParameters) {
            this.includeQueryParameters = includeQueryParameters;
        }

        @Override
        public final Builder includeQueryParameters(String includeQueryParameters) {
            this.includeQueryParameters = includeQueryParameters;
            return this;
        }

        @Override
        public final Builder includeQueryParameters(ServiceConnectIncludeQueryParameters includeQueryParameters) {
            this.includeQueryParameters(includeQueryParameters == null ? null : includeQueryParameters.toString());
            return this;
        }

        @Override
        public ServiceConnectAccessLogConfiguration build() {
            return new ServiceConnectAccessLogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
