/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CanaryConfiguration;
import software.amazon.awssdk.services.ecs.model.DeploymentAlarms;
import software.amazon.awssdk.services.ecs.model.DeploymentCircuitBreaker;
import software.amazon.awssdk.services.ecs.model.DeploymentLifecycleHook;
import software.amazon.awssdk.services.ecs.model.DeploymentLifecycleHookListCopier;
import software.amazon.awssdk.services.ecs.model.DeploymentStrategy;
import software.amazon.awssdk.services.ecs.model.LinearConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentConfiguration> {
    private static final SdkField<DeploymentCircuitBreaker> DEPLOYMENT_CIRCUIT_BREAKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentCircuitBreaker").getter(DeploymentConfiguration.getter(DeploymentConfiguration::deploymentCircuitBreaker)).setter(DeploymentConfiguration.setter(Builder::deploymentCircuitBreaker)).constructor(DeploymentCircuitBreaker::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentCircuitBreaker").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumPercent").getter(DeploymentConfiguration.getter(DeploymentConfiguration::maximumPercent)).setter(DeploymentConfiguration.setter(Builder::maximumPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPercent").build()}).build();
    private static final SdkField<Integer> MINIMUM_HEALTHY_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumHealthyPercent").getter(DeploymentConfiguration.getter(DeploymentConfiguration::minimumHealthyPercent)).setter(DeploymentConfiguration.setter(Builder::minimumHealthyPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumHealthyPercent").build()}).build();
    private static final SdkField<DeploymentAlarms> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarms").getter(DeploymentConfiguration.getter(DeploymentConfiguration::alarms)).setter(DeploymentConfiguration.setter(Builder::alarms)).constructor(DeploymentAlarms::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarms").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("strategy").getter(DeploymentConfiguration.getter(DeploymentConfiguration::strategyAsString)).setter(DeploymentConfiguration.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategy").build()}).build();
    private static final SdkField<Integer> BAKE_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("bakeTimeInMinutes").getter(DeploymentConfiguration.getter(DeploymentConfiguration::bakeTimeInMinutes)).setter(DeploymentConfiguration.setter(Builder::bakeTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bakeTimeInMinutes").build()}).build();
    private static final SdkField<List<DeploymentLifecycleHook>> LIFECYCLE_HOOKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lifecycleHooks").getter(DeploymentConfiguration.getter(DeploymentConfiguration::lifecycleHooks)).setter(DeploymentConfiguration.setter(Builder::lifecycleHooks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleHooks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentLifecycleHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LinearConfiguration> LINEAR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("linearConfiguration").getter(DeploymentConfiguration.getter(DeploymentConfiguration::linearConfiguration)).setter(DeploymentConfiguration.setter(Builder::linearConfiguration)).constructor(LinearConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linearConfiguration").build()}).build();
    private static final SdkField<CanaryConfiguration> CANARY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("canaryConfiguration").getter(DeploymentConfiguration.getter(DeploymentConfiguration::canaryConfiguration)).setter(DeploymentConfiguration.setter(Builder::canaryConfiguration)).constructor(CanaryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canaryConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CIRCUIT_BREAKER_FIELD, MAXIMUM_PERCENT_FIELD, MINIMUM_HEALTHY_PERCENT_FIELD, ALARMS_FIELD, STRATEGY_FIELD, BAKE_TIME_IN_MINUTES_FIELD, LIFECYCLE_HOOKS_FIELD, LINEAR_CONFIGURATION_FIELD, CANARY_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DeploymentCircuitBreaker deploymentCircuitBreaker;
    private final Integer maximumPercent;
    private final Integer minimumHealthyPercent;
    private final DeploymentAlarms alarms;
    private final String strategy;
    private final Integer bakeTimeInMinutes;
    private final List<DeploymentLifecycleHook> lifecycleHooks;
    private final LinearConfiguration linearConfiguration;
    private final CanaryConfiguration canaryConfiguration;

    private DeploymentConfiguration(BuilderImpl builder) {
        this.deploymentCircuitBreaker = builder.deploymentCircuitBreaker;
        this.maximumPercent = builder.maximumPercent;
        this.minimumHealthyPercent = builder.minimumHealthyPercent;
        this.alarms = builder.alarms;
        this.strategy = builder.strategy;
        this.bakeTimeInMinutes = builder.bakeTimeInMinutes;
        this.lifecycleHooks = builder.lifecycleHooks;
        this.linearConfiguration = builder.linearConfiguration;
        this.canaryConfiguration = builder.canaryConfiguration;
    }

    public final DeploymentCircuitBreaker deploymentCircuitBreaker() {
        return this.deploymentCircuitBreaker;
    }

    public final Integer maximumPercent() {
        return this.maximumPercent;
    }

    public final Integer minimumHealthyPercent() {
        return this.minimumHealthyPercent;
    }

    public final DeploymentAlarms alarms() {
        return this.alarms;
    }

    public final DeploymentStrategy strategy() {
        return DeploymentStrategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public final Integer bakeTimeInMinutes() {
        return this.bakeTimeInMinutes;
    }

    public final boolean hasLifecycleHooks() {
        return this.lifecycleHooks != null && !(this.lifecycleHooks instanceof SdkAutoConstructList);
    }

    public final List<DeploymentLifecycleHook> lifecycleHooks() {
        return this.lifecycleHooks;
    }

    public final LinearConfiguration linearConfiguration() {
        return this.linearConfiguration;
    }

    public final CanaryConfiguration canaryConfiguration() {
        return this.canaryConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentCircuitBreaker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumHealthyPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarms());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleHooks() ? this.lifecycleHooks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.linearConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.canaryConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfiguration)) {
            return false;
        }
        DeploymentConfiguration other = (DeploymentConfiguration)obj;
        return Objects.equals(this.deploymentCircuitBreaker(), other.deploymentCircuitBreaker()) && Objects.equals(this.maximumPercent(), other.maximumPercent()) && Objects.equals(this.minimumHealthyPercent(), other.minimumHealthyPercent()) && Objects.equals(this.alarms(), other.alarms()) && Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.bakeTimeInMinutes(), other.bakeTimeInMinutes()) && this.hasLifecycleHooks() == other.hasLifecycleHooks() && Objects.equals(this.lifecycleHooks(), other.lifecycleHooks()) && Objects.equals(this.linearConfiguration(), other.linearConfiguration()) && Objects.equals(this.canaryConfiguration(), other.canaryConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentConfiguration").add("DeploymentCircuitBreaker", (Object)this.deploymentCircuitBreaker()).add("MaximumPercent", (Object)this.maximumPercent()).add("MinimumHealthyPercent", (Object)this.minimumHealthyPercent()).add("Alarms", (Object)this.alarms()).add("Strategy", (Object)this.strategyAsString()).add("BakeTimeInMinutes", (Object)this.bakeTimeInMinutes()).add("LifecycleHooks", this.hasLifecycleHooks() ? this.lifecycleHooks() : null).add("LinearConfiguration", (Object)this.linearConfiguration()).add("CanaryConfiguration", (Object)this.canaryConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentCircuitBreaker": {
                return Optional.ofNullable(clazz.cast(this.deploymentCircuitBreaker()));
            }
            case "maximumPercent": {
                return Optional.ofNullable(clazz.cast(this.maximumPercent()));
            }
            case "minimumHealthyPercent": {
                return Optional.ofNullable(clazz.cast(this.minimumHealthyPercent()));
            }
            case "alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
            case "strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "bakeTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.bakeTimeInMinutes()));
            }
            case "lifecycleHooks": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHooks()));
            }
            case "linearConfiguration": {
                return Optional.ofNullable(clazz.cast(this.linearConfiguration()));
            }
            case "canaryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.canaryConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deploymentCircuitBreaker", DEPLOYMENT_CIRCUIT_BREAKER_FIELD);
        map.put("maximumPercent", MAXIMUM_PERCENT_FIELD);
        map.put("minimumHealthyPercent", MINIMUM_HEALTHY_PERCENT_FIELD);
        map.put("alarms", ALARMS_FIELD);
        map.put("strategy", STRATEGY_FIELD);
        map.put("bakeTimeInMinutes", BAKE_TIME_IN_MINUTES_FIELD);
        map.put("lifecycleHooks", LIFECYCLE_HOOKS_FIELD);
        map.put("linearConfiguration", LINEAR_CONFIGURATION_FIELD);
        map.put("canaryConfiguration", CANARY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfiguration, T> g) {
        return obj -> g.apply((DeploymentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DeploymentCircuitBreaker deploymentCircuitBreaker;
        private Integer maximumPercent;
        private Integer minimumHealthyPercent;
        private DeploymentAlarms alarms;
        private String strategy;
        private Integer bakeTimeInMinutes;
        private List<DeploymentLifecycleHook> lifecycleHooks = DefaultSdkAutoConstructList.getInstance();
        private LinearConfiguration linearConfiguration;
        private CanaryConfiguration canaryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfiguration model) {
            this.deploymentCircuitBreaker(model.deploymentCircuitBreaker);
            this.maximumPercent(model.maximumPercent);
            this.minimumHealthyPercent(model.minimumHealthyPercent);
            this.alarms(model.alarms);
            this.strategy(model.strategy);
            this.bakeTimeInMinutes(model.bakeTimeInMinutes);
            this.lifecycleHooks(model.lifecycleHooks);
            this.linearConfiguration(model.linearConfiguration);
            this.canaryConfiguration(model.canaryConfiguration);
        }

        public final DeploymentCircuitBreaker.Builder getDeploymentCircuitBreaker() {
            return this.deploymentCircuitBreaker != null ? this.deploymentCircuitBreaker.toBuilder() : null;
        }

        public final void setDeploymentCircuitBreaker(DeploymentCircuitBreaker.BuilderImpl deploymentCircuitBreaker) {
            this.deploymentCircuitBreaker = deploymentCircuitBreaker != null ? deploymentCircuitBreaker.build() : null;
        }

        @Override
        public final Builder deploymentCircuitBreaker(DeploymentCircuitBreaker deploymentCircuitBreaker) {
            this.deploymentCircuitBreaker = deploymentCircuitBreaker;
            return this;
        }

        public final Integer getMaximumPercent() {
            return this.maximumPercent;
        }

        public final void setMaximumPercent(Integer maximumPercent) {
            this.maximumPercent = maximumPercent;
        }

        @Override
        public final Builder maximumPercent(Integer maximumPercent) {
            this.maximumPercent = maximumPercent;
            return this;
        }

        public final Integer getMinimumHealthyPercent() {
            return this.minimumHealthyPercent;
        }

        public final void setMinimumHealthyPercent(Integer minimumHealthyPercent) {
            this.minimumHealthyPercent = minimumHealthyPercent;
        }

        @Override
        public final Builder minimumHealthyPercent(Integer minimumHealthyPercent) {
            this.minimumHealthyPercent = minimumHealthyPercent;
            return this;
        }

        public final DeploymentAlarms.Builder getAlarms() {
            return this.alarms != null ? this.alarms.toBuilder() : null;
        }

        public final void setAlarms(DeploymentAlarms.BuilderImpl alarms) {
            this.alarms = alarms != null ? alarms.build() : null;
        }

        @Override
        public final Builder alarms(DeploymentAlarms alarms) {
            this.alarms = alarms;
            return this;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(DeploymentStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final Integer getBakeTimeInMinutes() {
            return this.bakeTimeInMinutes;
        }

        public final void setBakeTimeInMinutes(Integer bakeTimeInMinutes) {
            this.bakeTimeInMinutes = bakeTimeInMinutes;
        }

        @Override
        public final Builder bakeTimeInMinutes(Integer bakeTimeInMinutes) {
            this.bakeTimeInMinutes = bakeTimeInMinutes;
            return this;
        }

        public final List<DeploymentLifecycleHook.Builder> getLifecycleHooks() {
            List<DeploymentLifecycleHook.Builder> result = DeploymentLifecycleHookListCopier.copyToBuilder(this.lifecycleHooks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecycleHooks(Collection<DeploymentLifecycleHook.BuilderImpl> lifecycleHooks) {
            this.lifecycleHooks = DeploymentLifecycleHookListCopier.copyFromBuilder(lifecycleHooks);
        }

        @Override
        public final Builder lifecycleHooks(Collection<DeploymentLifecycleHook> lifecycleHooks) {
            this.lifecycleHooks = DeploymentLifecycleHookListCopier.copy(lifecycleHooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(DeploymentLifecycleHook ... lifecycleHooks) {
            this.lifecycleHooks(Arrays.asList(lifecycleHooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(Consumer<DeploymentLifecycleHook.Builder> ... lifecycleHooks) {
            this.lifecycleHooks(Stream.of(lifecycleHooks).map(c -> (DeploymentLifecycleHook)((DeploymentLifecycleHook.Builder)DeploymentLifecycleHook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LinearConfiguration.Builder getLinearConfiguration() {
            return this.linearConfiguration != null ? this.linearConfiguration.toBuilder() : null;
        }

        public final void setLinearConfiguration(LinearConfiguration.BuilderImpl linearConfiguration) {
            this.linearConfiguration = linearConfiguration != null ? linearConfiguration.build() : null;
        }

        @Override
        public final Builder linearConfiguration(LinearConfiguration linearConfiguration) {
            this.linearConfiguration = linearConfiguration;
            return this;
        }

        public final CanaryConfiguration.Builder getCanaryConfiguration() {
            return this.canaryConfiguration != null ? this.canaryConfiguration.toBuilder() : null;
        }

        public final void setCanaryConfiguration(CanaryConfiguration.BuilderImpl canaryConfiguration) {
            this.canaryConfiguration = canaryConfiguration != null ? canaryConfiguration.build() : null;
        }

        @Override
        public final Builder canaryConfiguration(CanaryConfiguration canaryConfiguration) {
            this.canaryConfiguration = canaryConfiguration;
            return this;
        }

        public DeploymentConfiguration build() {
            return new DeploymentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentConfiguration> {
        public Builder deploymentCircuitBreaker(DeploymentCircuitBreaker var1);

        default public Builder deploymentCircuitBreaker(Consumer<DeploymentCircuitBreaker.Builder> deploymentCircuitBreaker) {
            return this.deploymentCircuitBreaker((DeploymentCircuitBreaker)((DeploymentCircuitBreaker.Builder)DeploymentCircuitBreaker.builder().applyMutation(deploymentCircuitBreaker)).build());
        }

        public Builder maximumPercent(Integer var1);

        public Builder minimumHealthyPercent(Integer var1);

        public Builder alarms(DeploymentAlarms var1);

        default public Builder alarms(Consumer<DeploymentAlarms.Builder> alarms) {
            return this.alarms((DeploymentAlarms)((DeploymentAlarms.Builder)DeploymentAlarms.builder().applyMutation(alarms)).build());
        }

        public Builder strategy(String var1);

        public Builder strategy(DeploymentStrategy var1);

        public Builder bakeTimeInMinutes(Integer var1);

        public Builder lifecycleHooks(Collection<DeploymentLifecycleHook> var1);

        public Builder lifecycleHooks(DeploymentLifecycleHook ... var1);

        public Builder lifecycleHooks(Consumer<DeploymentLifecycleHook.Builder> ... var1);

        public Builder linearConfiguration(LinearConfiguration var1);

        default public Builder linearConfiguration(Consumer<LinearConfiguration.Builder> linearConfiguration) {
            return this.linearConfiguration((LinearConfiguration)((LinearConfiguration.Builder)LinearConfiguration.builder().applyMutation(linearConfiguration)).build());
        }

        public Builder canaryConfiguration(CanaryConfiguration var1);

        default public Builder canaryConfiguration(Consumer<CanaryConfiguration.Builder> canaryConfiguration) {
            return this.canaryConfiguration((CanaryConfiguration)((CanaryConfiguration.Builder)CanaryConfiguration.builder().applyMutation(canaryConfiguration)).build());
        }
    }
}

