/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClustersRequest extends EcsRequest implements
        ToCopyableBuilder<DescribeClustersRequest.Builder, DescribeClustersRequest> {
    private static final SdkField<List<String>> CLUSTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("clusters")
            .getter(getter(DescribeClustersRequest::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("include")
            .getter(getter(DescribeClustersRequest::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLUSTERS_FIELD, INCLUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> clusters;

    private final List<String> include;

    private DescribeClustersRequest(BuilderImpl builder) {
        super(builder);
        this.clusters = builder.clusters;
        this.include = builder.include;
    }

    /**
     * For responses, this returns true if the service returned a value for the Clusters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a
     * cluster, the default cluster is assumed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusters} method.
     * </p>
     * 
     * @return A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not
     *         specify a cluster, the default cluster is assumed.
     */
    public final List<String> clusters() {
        return clusters;
    }

    /**
     * <p>
     * Determines whether to include additional information about the clusters in the response. If this field is
     * omitted, this information isn't included.
     * </p>
     * <p>
     * If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the cluster
     * are included, for example the capacity providers.
     * </p>
     * <p>
     * If <code>SETTINGS</code> is specified, the settings for the cluster are included.
     * </p>
     * <p>
     * If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
     * </p>
     * <p>
     * If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch type.
     * </p>
     * <p>
     * If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Determines whether to include additional information about the clusters in the response. If this field is
     *         omitted, this information isn't included.</p>
     *         <p>
     *         If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the
     *         cluster are included, for example the capacity providers.
     *         </p>
     *         <p>
     *         If <code>SETTINGS</code> is specified, the settings for the cluster are included.
     *         </p>
     *         <p>
     *         If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
     *         </p>
     *         <p>
     *         If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch
     *         type.
     *         </p>
     *         <p>
     *         If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
     */
    public final List<ClusterField> include() {
        return ClusterFieldListCopier.copyStringToEnum(include);
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines whether to include additional information about the clusters in the response. If this field is
     * omitted, this information isn't included.
     * </p>
     * <p>
     * If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the cluster
     * are included, for example the capacity providers.
     * </p>
     * <p>
     * If <code>SETTINGS</code> is specified, the settings for the cluster are included.
     * </p>
     * <p>
     * If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
     * </p>
     * <p>
     * If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch type.
     * </p>
     * <p>
     * If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Determines whether to include additional information about the clusters in the response. If this field is
     *         omitted, this information isn't included.</p>
     *         <p>
     *         If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the
     *         cluster are included, for example the capacity providers.
     *         </p>
     *         <p>
     *         If <code>SETTINGS</code> is specified, the settings for the cluster are included.
     *         </p>
     *         <p>
     *         If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
     *         </p>
     *         <p>
     *         If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch
     *         type.
     *         </p>
     *         <p>
     *         If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
     */
    public final List<String> includeAsStrings() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClusters() ? clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? includeAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersRequest)) {
            return false;
        }
        DescribeClustersRequest other = (DescribeClustersRequest) obj;
        return hasClusters() == other.hasClusters() && Objects.equals(clusters(), other.clusters())
                && hasInclude() == other.hasInclude() && Objects.equals(includeAsStrings(), other.includeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClustersRequest").add("Clusters", hasClusters() ? clusters() : null)
                .add("Include", hasInclude() ? includeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        case "include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusters", CLUSTERS_FIELD);
        map.put("include", INCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClustersRequest, T> g) {
        return obj -> g.apply((DescribeClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClustersRequest> {
        /**
         * <p>
         * A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a
         * cluster, the default cluster is assumed.
         * </p>
         * 
         * @param clusters
         *        A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not
         *        specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<String> clusters);

        /**
         * <p>
         * A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a
         * cluster, the default cluster is assumed.
         * </p>
         * 
         * @param clusters
         *        A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not
         *        specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(String... clusters);

        /**
         * <p>
         * Determines whether to include additional information about the clusters in the response. If this field is
         * omitted, this information isn't included.
         * </p>
         * <p>
         * If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the
         * cluster are included, for example the capacity providers.
         * </p>
         * <p>
         * If <code>SETTINGS</code> is specified, the settings for the cluster are included.
         * </p>
         * <p>
         * If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
         * </p>
         * <p>
         * If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch type.
         * </p>
         * <p>
         * If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
         * </p>
         * 
         * @param include
         *        Determines whether to include additional information about the clusters in the response. If this field
         *        is omitted, this information isn't included.</p>
         *        <p>
         *        If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within
         *        the cluster are included, for example the capacity providers.
         *        </p>
         *        <p>
         *        If <code>SETTINGS</code> is specified, the settings for the cluster are included.
         *        </p>
         *        <p>
         *        If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
         *        </p>
         *        <p>
         *        If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch
         *        type.
         *        </p>
         *        <p>
         *        If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Collection<String> include);

        /**
         * <p>
         * Determines whether to include additional information about the clusters in the response. If this field is
         * omitted, this information isn't included.
         * </p>
         * <p>
         * If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the
         * cluster are included, for example the capacity providers.
         * </p>
         * <p>
         * If <code>SETTINGS</code> is specified, the settings for the cluster are included.
         * </p>
         * <p>
         * If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
         * </p>
         * <p>
         * If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch type.
         * </p>
         * <p>
         * If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
         * </p>
         * 
         * @param include
         *        Determines whether to include additional information about the clusters in the response. If this field
         *        is omitted, this information isn't included.</p>
         *        <p>
         *        If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within
         *        the cluster are included, for example the capacity providers.
         *        </p>
         *        <p>
         *        If <code>SETTINGS</code> is specified, the settings for the cluster are included.
         *        </p>
         *        <p>
         *        If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
         *        </p>
         *        <p>
         *        If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch
         *        type.
         *        </p>
         *        <p>
         *        If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(String... include);

        /**
         * <p>
         * Determines whether to include additional information about the clusters in the response. If this field is
         * omitted, this information isn't included.
         * </p>
         * <p>
         * If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the
         * cluster are included, for example the capacity providers.
         * </p>
         * <p>
         * If <code>SETTINGS</code> is specified, the settings for the cluster are included.
         * </p>
         * <p>
         * If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
         * </p>
         * <p>
         * If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch type.
         * </p>
         * <p>
         * If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
         * </p>
         * 
         * @param include
         *        Determines whether to include additional information about the clusters in the response. If this field
         *        is omitted, this information isn't included.</p>
         *        <p>
         *        If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within
         *        the cluster are included, for example the capacity providers.
         *        </p>
         *        <p>
         *        If <code>SETTINGS</code> is specified, the settings for the cluster are included.
         *        </p>
         *        <p>
         *        If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
         *        </p>
         *        <p>
         *        If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch
         *        type.
         *        </p>
         *        <p>
         *        If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<ClusterField> include);

        /**
         * <p>
         * Determines whether to include additional information about the clusters in the response. If this field is
         * omitted, this information isn't included.
         * </p>
         * <p>
         * If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the
         * cluster are included, for example the capacity providers.
         * </p>
         * <p>
         * If <code>SETTINGS</code> is specified, the settings for the cluster are included.
         * </p>
         * <p>
         * If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
         * </p>
         * <p>
         * If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch type.
         * </p>
         * <p>
         * If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
         * </p>
         * 
         * @param include
         *        Determines whether to include additional information about the clusters in the response. If this field
         *        is omitted, this information isn't included.</p>
         *        <p>
         *        If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within
         *        the cluster are included, for example the capacity providers.
         *        </p>
         *        <p>
         *        If <code>SETTINGS</code> is specified, the settings for the cluster are included.
         *        </p>
         *        <p>
         *        If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.
         *        </p>
         *        <p>
         *        If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch
         *        type.
         *        </p>
         *        <p>
         *        If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(ClusterField... include);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private List<String> clusters = DefaultSdkAutoConstructList.getInstance();

        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersRequest model) {
            super(model);
            clusters(model.clusters);
            includeWithStrings(model.include);
        }

        public final Collection<String> getClusters() {
            if (clusters instanceof SdkAutoConstructList) {
                return null;
            }
            return clusters;
        }

        public final void setClusters(Collection<String> clusters) {
            this.clusters = StringListCopier.copy(clusters);
        }

        @Override
        public final Builder clusters(Collection<String> clusters) {
            this.clusters = StringListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(String... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        public final Collection<String> getInclude() {
            if (include instanceof SdkAutoConstructList) {
                return null;
            }
            return include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = ClusterFieldListCopier.copy(include);
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = ClusterFieldListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String... include) {
            includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<ClusterField> include) {
            this.include = ClusterFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(ClusterField... include) {
            include(Arrays.asList(include));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClustersRequest build() {
            return new DescribeClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
