/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The test traffic routing configuration for Amazon ECS blue/green deployments. This configuration allows you to define
 * rules for routing specific traffic to the new service revision during the deployment process, allowing for safe
 * testing before full production traffic shift.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect-blue-green.html">Service Connect
 * for Amazon ECS blue/green deployments</a> in the <i> Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceConnectTestTrafficRules implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceConnectTestTrafficRules.Builder, ServiceConnectTestTrafficRules> {
    private static final SdkField<ServiceConnectTestTrafficHeaderRules> HEADER_FIELD = SdkField
            .<ServiceConnectTestTrafficHeaderRules> builder(MarshallingType.SDK_POJO).memberName("header")
            .getter(getter(ServiceConnectTestTrafficRules::header)).setter(setter(Builder::header))
            .constructor(ServiceConnectTestTrafficHeaderRules::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("header").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceConnectTestTrafficHeaderRules header;

    private ServiceConnectTestTrafficRules(BuilderImpl builder) {
        this.header = builder.header;
    }

    /**
     * <p>
     * The HTTP header-based routing rules that determine which requests should be routed to the new service version
     * during blue/green deployment testing. These rules provide fine-grained control over test traffic routing based on
     * request headers.
     * </p>
     * 
     * @return The HTTP header-based routing rules that determine which requests should be routed to the new service
     *         version during blue/green deployment testing. These rules provide fine-grained control over test traffic
     *         routing based on request headers.
     */
    public final ServiceConnectTestTrafficHeaderRules header() {
        return header;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(header());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectTestTrafficRules)) {
            return false;
        }
        ServiceConnectTestTrafficRules other = (ServiceConnectTestTrafficRules) obj;
        return Objects.equals(header(), other.header());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceConnectTestTrafficRules").add("Header", header()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "header":
            return Optional.ofNullable(clazz.cast(header()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("header", HEADER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectTestTrafficRules, T> g) {
        return obj -> g.apply((ServiceConnectTestTrafficRules) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceConnectTestTrafficRules> {
        /**
         * <p>
         * The HTTP header-based routing rules that determine which requests should be routed to the new service version
         * during blue/green deployment testing. These rules provide fine-grained control over test traffic routing
         * based on request headers.
         * </p>
         * 
         * @param header
         *        The HTTP header-based routing rules that determine which requests should be routed to the new service
         *        version during blue/green deployment testing. These rules provide fine-grained control over test
         *        traffic routing based on request headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(ServiceConnectTestTrafficHeaderRules header);

        /**
         * <p>
         * The HTTP header-based routing rules that determine which requests should be routed to the new service version
         * during blue/green deployment testing. These rules provide fine-grained control over test traffic routing
         * based on request headers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceConnectTestTrafficHeaderRules.Builder} avoiding the need to create one manually via
         * {@link ServiceConnectTestTrafficHeaderRules#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceConnectTestTrafficHeaderRules.Builder#build()} is called
         * immediately and its result is passed to {@link #header(ServiceConnectTestTrafficHeaderRules)}.
         * 
         * @param header
         *        a consumer that will call methods on {@link ServiceConnectTestTrafficHeaderRules.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #header(ServiceConnectTestTrafficHeaderRules)
         */
        default Builder header(Consumer<ServiceConnectTestTrafficHeaderRules.Builder> header) {
            return header(ServiceConnectTestTrafficHeaderRules.builder().applyMutation(header).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceConnectTestTrafficHeaderRules header;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectTestTrafficRules model) {
            header(model.header);
        }

        public final ServiceConnectTestTrafficHeaderRules.Builder getHeader() {
            return header != null ? header.toBuilder() : null;
        }

        public final void setHeader(ServiceConnectTestTrafficHeaderRules.BuilderImpl header) {
            this.header = header != null ? header.build() : null;
        }

        @Override
        public final Builder header(ServiceConnectTestTrafficHeaderRules header) {
            this.header = header;
            return this;
        }

        @Override
        public ServiceConnectTestTrafficRules build() {
            return new ServiceConnectTestTrafficRules(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
