/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopServiceDeploymentRequest extends EcsRequest implements
        ToCopyableBuilder<StopServiceDeploymentRequest.Builder, StopServiceDeploymentRequest> {
    private static final SdkField<String> SERVICE_DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceDeploymentArn").getter(getter(StopServiceDeploymentRequest::serviceDeploymentArn))
            .setter(setter(Builder::serviceDeploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeploymentArn").build())
            .build();

    private static final SdkField<String> STOP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stopType").getter(getter(StopServiceDeploymentRequest::stopTypeAsString))
            .setter(setter(Builder::stopType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENT_ARN_FIELD,
            STOP_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceDeploymentArn;

    private final String stopType;

    private StopServiceDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.serviceDeploymentArn = builder.serviceDeploymentArn;
        this.stopType = builder.stopType;
    }

    /**
     * <p>
     * The ARN of the service deployment that you want to stop.
     * </p>
     * 
     * @return The ARN of the service deployment that you want to stop.
     */
    public final String serviceDeploymentArn() {
        return serviceDeploymentArn;
    }

    /**
     * <p>
     * How you want Amazon ECS to stop the service.
     * </p>
     * <p>
     * The valid values are <code>ROLLBACK</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopType} will
     * return {@link StopServiceDeploymentStopType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stopTypeAsString}.
     * </p>
     * 
     * @return How you want Amazon ECS to stop the service. </p>
     *         <p>
     *         The valid values are <code>ROLLBACK</code>.
     * @see StopServiceDeploymentStopType
     */
    public final StopServiceDeploymentStopType stopType() {
        return StopServiceDeploymentStopType.fromValue(stopType);
    }

    /**
     * <p>
     * How you want Amazon ECS to stop the service.
     * </p>
     * <p>
     * The valid values are <code>ROLLBACK</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopType} will
     * return {@link StopServiceDeploymentStopType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stopTypeAsString}.
     * </p>
     * 
     * @return How you want Amazon ECS to stop the service. </p>
     *         <p>
     *         The valid values are <code>ROLLBACK</code>.
     * @see StopServiceDeploymentStopType
     */
    public final String stopTypeAsString() {
        return stopType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceDeploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(stopTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopServiceDeploymentRequest)) {
            return false;
        }
        StopServiceDeploymentRequest other = (StopServiceDeploymentRequest) obj;
        return Objects.equals(serviceDeploymentArn(), other.serviceDeploymentArn())
                && Objects.equals(stopTypeAsString(), other.stopTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopServiceDeploymentRequest").add("ServiceDeploymentArn", serviceDeploymentArn())
                .add("StopType", stopTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceDeploymentArn":
            return Optional.ofNullable(clazz.cast(serviceDeploymentArn()));
        case "stopType":
            return Optional.ofNullable(clazz.cast(stopTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceDeploymentArn", SERVICE_DEPLOYMENT_ARN_FIELD);
        map.put("stopType", STOP_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopServiceDeploymentRequest, T> g) {
        return obj -> g.apply((StopServiceDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopServiceDeploymentRequest> {
        /**
         * <p>
         * The ARN of the service deployment that you want to stop.
         * </p>
         * 
         * @param serviceDeploymentArn
         *        The ARN of the service deployment that you want to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDeploymentArn(String serviceDeploymentArn);

        /**
         * <p>
         * How you want Amazon ECS to stop the service.
         * </p>
         * <p>
         * The valid values are <code>ROLLBACK</code>.
         * </p>
         * 
         * @param stopType
         *        How you want Amazon ECS to stop the service. </p>
         *        <p>
         *        The valid values are <code>ROLLBACK</code>.
         * @see StopServiceDeploymentStopType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopServiceDeploymentStopType
         */
        Builder stopType(String stopType);

        /**
         * <p>
         * How you want Amazon ECS to stop the service.
         * </p>
         * <p>
         * The valid values are <code>ROLLBACK</code>.
         * </p>
         * 
         * @param stopType
         *        How you want Amazon ECS to stop the service. </p>
         *        <p>
         *        The valid values are <code>ROLLBACK</code>.
         * @see StopServiceDeploymentStopType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopServiceDeploymentStopType
         */
        Builder stopType(StopServiceDeploymentStopType stopType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String serviceDeploymentArn;

        private String stopType;

        private BuilderImpl() {
        }

        private BuilderImpl(StopServiceDeploymentRequest model) {
            super(model);
            serviceDeploymentArn(model.serviceDeploymentArn);
            stopType(model.stopType);
        }

        public final String getServiceDeploymentArn() {
            return serviceDeploymentArn;
        }

        public final void setServiceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
        }

        @Override
        public final Builder serviceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
            return this;
        }

        public final String getStopType() {
            return stopType;
        }

        public final void setStopType(String stopType) {
            this.stopType = stopType;
        }

        @Override
        public final Builder stopType(String stopType) {
            this.stopType = stopType;
            return this;
        }

        @Override
        public final Builder stopType(StopServiceDeploymentStopType stopType) {
            this.stopType(stopType == null ? null : stopType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopServiceDeploymentRequest build() {
            return new StopServiceDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
