/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rollback
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rollback> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(Rollback.getter(Rollback::reason)).setter(Rollback.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(Rollback.getter(Rollback::startedAt)).setter(Rollback.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<String> SERVICE_REVISION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRevisionArn").getter(Rollback.getter(Rollback::serviceRevisionArn)).setter(Rollback.setter(Builder::serviceRevisionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRevisionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, STARTED_AT_FIELD, SERVICE_REVISION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Rollback.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final Instant startedAt;
    private final String serviceRevisionArn;

    private Rollback(BuilderImpl builder) {
        this.reason = builder.reason;
        this.startedAt = builder.startedAt;
        this.serviceRevisionArn = builder.serviceRevisionArn;
    }

    public final String reason() {
        return this.reason;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final String serviceRevisionArn() {
        return this.serviceRevisionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRevisionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rollback)) {
            return false;
        }
        Rollback other = (Rollback)obj;
        return Objects.equals(this.reason(), other.reason()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.serviceRevisionArn(), other.serviceRevisionArn());
    }

    public final String toString() {
        return ToString.builder((String)"Rollback").add("Reason", (Object)this.reason()).add("StartedAt", (Object)this.startedAt()).add("ServiceRevisionArn", (Object)this.serviceRevisionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "serviceRevisionArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRevisionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reason", REASON_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("serviceRevisionArn", SERVICE_REVISION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rollback, T> g) {
        return obj -> g.apply((Rollback)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reason;
        private Instant startedAt;
        private String serviceRevisionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Rollback model) {
            this.reason(model.reason);
            this.startedAt(model.startedAt);
            this.serviceRevisionArn(model.serviceRevisionArn);
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getServiceRevisionArn() {
            return this.serviceRevisionArn;
        }

        public final void setServiceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
        }

        @Override
        public final Builder serviceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
            return this;
        }

        public Rollback build() {
            return new Rollback(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rollback> {
        public Builder reason(String var1);

        public Builder startedAt(Instant var1);

        public Builder serviceRevisionArn(String var1);
    }
}

