/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.Failure;
import software.amazon.awssdk.services.ecs.model.FailuresCopier;
import software.amazon.awssdk.services.ecs.model.ServiceRevision;
import software.amazon.awssdk.services.ecs.model.ServiceRevisionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceRevisionsResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, DescribeServiceRevisionsResponse> {
    private static final SdkField<List<ServiceRevision>> SERVICE_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceRevisions").getter(DescribeServiceRevisionsResponse.getter(DescribeServiceRevisionsResponse::serviceRevisions)).setter(DescribeServiceRevisionsResponse.setter(Builder::serviceRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRevisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(DescribeServiceRevisionsResponse.getter(DescribeServiceRevisionsResponse::failures)).setter(DescribeServiceRevisionsResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Failure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_REVISIONS_FIELD, FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServiceRevisionsResponse.memberNameToFieldInitializer();
    private final List<ServiceRevision> serviceRevisions;
    private final List<Failure> failures;

    private DescribeServiceRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceRevisions = builder.serviceRevisions;
        this.failures = builder.failures;
    }

    public final boolean hasServiceRevisions() {
        return this.serviceRevisions != null && !(this.serviceRevisions instanceof SdkAutoConstructList);
    }

    public final List<ServiceRevision> serviceRevisions() {
        return this.serviceRevisions;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<Failure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceRevisions() ? this.serviceRevisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceRevisionsResponse)) {
            return false;
        }
        DescribeServiceRevisionsResponse other = (DescribeServiceRevisionsResponse)((Object)obj);
        return this.hasServiceRevisions() == other.hasServiceRevisions() && Objects.equals(this.serviceRevisions(), other.serviceRevisions()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceRevisionsResponse").add("ServiceRevisions", this.hasServiceRevisions() ? this.serviceRevisions() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceRevisions": {
                return Optional.ofNullable(clazz.cast(this.serviceRevisions()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceRevisions", SERVICE_REVISIONS_FIELD);
        map.put("failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceRevisionsResponse, T> g) {
        return obj -> g.apply((DescribeServiceRevisionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<ServiceRevision> serviceRevisions = DefaultSdkAutoConstructList.getInstance();
        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceRevisionsResponse model) {
            super(model);
            this.serviceRevisions(model.serviceRevisions);
            this.failures(model.failures);
        }

        public final List<ServiceRevision.Builder> getServiceRevisions() {
            List<ServiceRevision.Builder> result = ServiceRevisionsCopier.copyToBuilder(this.serviceRevisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRevisions(Collection<ServiceRevision.BuilderImpl> serviceRevisions) {
            this.serviceRevisions = ServiceRevisionsCopier.copyFromBuilder(serviceRevisions);
        }

        @Override
        public final Builder serviceRevisions(Collection<ServiceRevision> serviceRevisions) {
            this.serviceRevisions = ServiceRevisionsCopier.copy(serviceRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRevisions(ServiceRevision ... serviceRevisions) {
            this.serviceRevisions(Arrays.asList(serviceRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRevisions(Consumer<ServiceRevision.Builder> ... serviceRevisions) {
            this.serviceRevisions(Stream.of(serviceRevisions).map(c -> (ServiceRevision)((ServiceRevision.Builder)ServiceRevision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (Failure)((Failure.Builder)Failure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeServiceRevisionsResponse build() {
            return new DescribeServiceRevisionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceRevisionsResponse> {
        public Builder serviceRevisions(Collection<ServiceRevision> var1);

        public Builder serviceRevisions(ServiceRevision ... var1);

        public Builder serviceRevisions(Consumer<ServiceRevision.Builder> ... var1);

        public Builder failures(Collection<Failure> var1);

        public Builder failures(Failure ... var1);

        public Builder failures(Consumer<Failure.Builder> ... var1);
    }
}

