/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedTask> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskArn").getter(ProtectedTask.getter(ProtectedTask::taskArn)).setter(ProtectedTask.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final SdkField<Boolean> PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("protectionEnabled").getter(ProtectedTask.getter(ProtectedTask::protectionEnabled)).setter(ProtectedTask.setter(Builder::protectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectionEnabled").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expirationDate").getter(ProtectedTask.getter(ProtectedTask::expirationDate)).setter(ProtectedTask.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, PROTECTION_ENABLED_FIELD, EXPIRATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskArn;
    private final Boolean protectionEnabled;
    private final Instant expirationDate;

    private ProtectedTask(BuilderImpl builder) {
        this.taskArn = builder.taskArn;
        this.protectionEnabled = builder.protectionEnabled;
        this.expirationDate = builder.expirationDate;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final Boolean protectionEnabled() {
        return this.protectionEnabled;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedTask)) {
            return false;
        }
        ProtectedTask other = (ProtectedTask)obj;
        return Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.protectionEnabled(), other.protectionEnabled()) && Objects.equals(this.expirationDate(), other.expirationDate());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedTask").add("TaskArn", (Object)this.taskArn()).add("ProtectionEnabled", (Object)this.protectionEnabled()).add("ExpirationDate", (Object)this.expirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "protectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.protectionEnabled()));
            }
            case "expirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectedTask, T> g) {
        return obj -> g.apply((ProtectedTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskArn;
        private Boolean protectionEnabled;
        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedTask model) {
            this.taskArn(model.taskArn);
            this.protectionEnabled(model.protectionEnabled);
            this.expirationDate(model.expirationDate);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Boolean getProtectionEnabled() {
            return this.protectionEnabled;
        }

        public final void setProtectionEnabled(Boolean protectionEnabled) {
            this.protectionEnabled = protectionEnabled;
        }

        @Override
        public final Builder protectionEnabled(Boolean protectionEnabled) {
            this.protectionEnabled = protectionEnabled;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public ProtectedTask build() {
            return new ProtectedTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedTask> {
        public Builder taskArn(String var1);

        public Builder protectionEnabled(Boolean var1);

        public Builder expirationDate(Instant var1);
    }
}

