/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EFSAuthorizationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EFSAuthorizationConfig> {
    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPointId").getter(EFSAuthorizationConfig.getter(EFSAuthorizationConfig::accessPointId)).setter(EFSAuthorizationConfig.setter(Builder::accessPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPointId").build()}).build();
    private static final SdkField<String> IAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iam").getter(EFSAuthorizationConfig.getter(EFSAuthorizationConfig::iamAsString)).setter(EFSAuthorizationConfig.setter(Builder::iam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iam").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ID_FIELD, IAM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessPointId;
    private final String iam;

    private EFSAuthorizationConfig(BuilderImpl builder) {
        this.accessPointId = builder.accessPointId;
        this.iam = builder.iam;
    }

    public final String accessPointId() {
        return this.accessPointId;
    }

    public final EFSAuthorizationConfigIAM iam() {
        return EFSAuthorizationConfigIAM.fromValue(this.iam);
    }

    public final String iamAsString() {
        return this.iam;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EFSAuthorizationConfig)) {
            return false;
        }
        EFSAuthorizationConfig other = (EFSAuthorizationConfig)obj;
        return Objects.equals(this.accessPointId(), other.accessPointId()) && Objects.equals(this.iamAsString(), other.iamAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EFSAuthorizationConfig").add("AccessPointId", (Object)this.accessPointId()).add("Iam", (Object)this.iamAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPointId": {
                return Optional.ofNullable(clazz.cast(this.accessPointId()));
            }
            case "iam": {
                return Optional.ofNullable(clazz.cast(this.iamAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EFSAuthorizationConfig, T> g) {
        return obj -> g.apply((EFSAuthorizationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessPointId;
        private String iam;

        private BuilderImpl() {
        }

        private BuilderImpl(EFSAuthorizationConfig model) {
            this.accessPointId(model.accessPointId);
            this.iam(model.iam);
        }

        public final String getAccessPointId() {
            return this.accessPointId;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        @Override
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final String getIam() {
            return this.iam;
        }

        public final void setIam(String iam) {
            this.iam = iam;
        }

        @Override
        public final Builder iam(String iam) {
            this.iam = iam;
            return this;
        }

        @Override
        public final Builder iam(EFSAuthorizationConfigIAM iam) {
            this.iam(iam == null ? null : iam.toString());
            return this;
        }

        public EFSAuthorizationConfig build() {
            return new EFSAuthorizationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EFSAuthorizationConfig> {
        public Builder accessPointId(String var1);

        public Builder iam(String var1);

        public Builder iam(EFSAuthorizationConfigIAM var1);
    }
}

