/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This parameter is specified when you're using <a
 * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html">Amazon FSx for Windows File Server</a> file
 * system for task storage.
 * </p>
 * <p>
 * For more information and the input format, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html">Amazon FSx for Windows File
 * Server volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FSxWindowsFileServerVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FSxWindowsFileServerVolumeConfiguration.Builder, FSxWindowsFileServerVolumeConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileSystemId").getter(getter(FSxWindowsFileServerVolumeConfiguration::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemId").build()).build();

    private static final SdkField<String> ROOT_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootDirectory").getter(getter(FSxWindowsFileServerVolumeConfiguration::rootDirectory))
            .setter(setter(Builder::rootDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDirectory").build()).build();

    private static final SdkField<FSxWindowsFileServerAuthorizationConfig> AUTHORIZATION_CONFIG_FIELD = SdkField
            .<FSxWindowsFileServerAuthorizationConfig> builder(MarshallingType.SDK_POJO).memberName("authorizationConfig")
            .getter(getter(FSxWindowsFileServerVolumeConfiguration::authorizationConfig))
            .setter(setter(Builder::authorizationConfig)).constructor(FSxWindowsFileServerAuthorizationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            ROOT_DIRECTORY_FIELD, AUTHORIZATION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileSystemId;

    private final String rootDirectory;

    private final FSxWindowsFileServerAuthorizationConfig authorizationConfig;

    private FSxWindowsFileServerVolumeConfiguration(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.rootDirectory = builder.rootDirectory;
        this.authorizationConfig = builder.authorizationConfig;
    }

    /**
     * <p>
     * The Amazon FSx for Windows File Server file system ID to use.
     * </p>
     * 
     * @return The Amazon FSx for Windows File Server file system ID to use.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the
     * host.
     * </p>
     * 
     * @return The directory within the Amazon FSx for Windows File Server file system to mount as the root directory
     *         inside the host.
     */
    public final String rootDirectory() {
        return rootDirectory;
    }

    /**
     * <p>
     * The authorization configuration details for the Amazon FSx for Windows File Server file system.
     * </p>
     * 
     * @return The authorization configuration details for the Amazon FSx for Windows File Server file system.
     */
    public final FSxWindowsFileServerAuthorizationConfig authorizationConfig() {
        return authorizationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(rootDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FSxWindowsFileServerVolumeConfiguration)) {
            return false;
        }
        FSxWindowsFileServerVolumeConfiguration other = (FSxWindowsFileServerVolumeConfiguration) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(rootDirectory(), other.rootDirectory())
                && Objects.equals(authorizationConfig(), other.authorizationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FSxWindowsFileServerVolumeConfiguration").add("FileSystemId", fileSystemId())
                .add("RootDirectory", rootDirectory()).add("AuthorizationConfig", authorizationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "rootDirectory":
            return Optional.ofNullable(clazz.cast(rootDirectory()));
        case "authorizationConfig":
            return Optional.ofNullable(clazz.cast(authorizationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FSxWindowsFileServerVolumeConfiguration, T> g) {
        return obj -> g.apply((FSxWindowsFileServerVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FSxWindowsFileServerVolumeConfiguration> {
        /**
         * <p>
         * The Amazon FSx for Windows File Server file system ID to use.
         * </p>
         * 
         * @param fileSystemId
         *        The Amazon FSx for Windows File Server file system ID to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside
         * the host.
         * </p>
         * 
         * @param rootDirectory
         *        The directory within the Amazon FSx for Windows File Server file system to mount as the root directory
         *        inside the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDirectory(String rootDirectory);

        /**
         * <p>
         * The authorization configuration details for the Amazon FSx for Windows File Server file system.
         * </p>
         * 
         * @param authorizationConfig
         *        The authorization configuration details for the Amazon FSx for Windows File Server file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationConfig(FSxWindowsFileServerAuthorizationConfig authorizationConfig);

        /**
         * <p>
         * The authorization configuration details for the Amazon FSx for Windows File Server file system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FSxWindowsFileServerAuthorizationConfig.Builder} avoiding the need to create one manually via
         * {@link FSxWindowsFileServerAuthorizationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FSxWindowsFileServerAuthorizationConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #authorizationConfig(FSxWindowsFileServerAuthorizationConfig)}.
         * 
         * @param authorizationConfig
         *        a consumer that will call methods on {@link FSxWindowsFileServerAuthorizationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationConfig(FSxWindowsFileServerAuthorizationConfig)
         */
        default Builder authorizationConfig(Consumer<FSxWindowsFileServerAuthorizationConfig.Builder> authorizationConfig) {
            return authorizationConfig(FSxWindowsFileServerAuthorizationConfig.builder().applyMutation(authorizationConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemId;

        private String rootDirectory;

        private FSxWindowsFileServerAuthorizationConfig authorizationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FSxWindowsFileServerVolumeConfiguration model) {
            fileSystemId(model.fileSystemId);
            rootDirectory(model.rootDirectory);
            authorizationConfig(model.authorizationConfig);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getRootDirectory() {
            return rootDirectory;
        }

        public final void setRootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
        }

        @Override
        public final Builder rootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public final FSxWindowsFileServerAuthorizationConfig.Builder getAuthorizationConfig() {
            return authorizationConfig != null ? authorizationConfig.toBuilder() : null;
        }

        public final void setAuthorizationConfig(FSxWindowsFileServerAuthorizationConfig.BuilderImpl authorizationConfig) {
            this.authorizationConfig = authorizationConfig != null ? authorizationConfig.build() : null;
        }

        @Override
        public final Builder authorizationConfig(FSxWindowsFileServerAuthorizationConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        @Override
        public FSxWindowsFileServerVolumeConfiguration build() {
            return new FSxWindowsFileServerVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
