/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTaskSetRequest extends EcsRequest implements
        ToCopyableBuilder<DeleteTaskSetRequest.Builder, DeleteTaskSetRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(DeleteTaskSetRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(DeleteTaskSetRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> TASK_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskSet").getter(getter(DeleteTaskSetRequest::taskSet)).setter(setter(Builder::taskSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSet").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("force")
            .getter(getter(DeleteTaskSetRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD,
            TASK_SET_FIELD, FORCE_FIELD));

    private final String cluster;

    private final String service;

    private final String taskSet;

    private final Boolean force;

    private DeleteTaskSetRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.taskSet = builder.taskSet;
        this.force = builder.force;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set found
     * in to delete.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set
     *         found in to delete.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to delete.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to delete.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The task set ID or full Amazon Resource Name (ARN) of the task set to delete.
     * </p>
     * 
     * @return The task set ID or full Amazon Resource Name (ARN) of the task set to delete.
     */
    public final String taskSet() {
        return taskSet;
    }

    /**
     * <p>
     * If <code>true</code>, you can delete a task set even if it hasn't been scaled down to zero.
     * </p>
     * 
     * @return If <code>true</code>, you can delete a task set even if it hasn't been scaled down to zero.
     */
    public final Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(taskSet());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTaskSetRequest)) {
            return false;
        }
        DeleteTaskSetRequest other = (DeleteTaskSetRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(service(), other.service())
                && Objects.equals(taskSet(), other.taskSet()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTaskSetRequest").add("Cluster", cluster()).add("Service", service())
                .add("TaskSet", taskSet()).add("Force", force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "taskSet":
            return Optional.ofNullable(clazz.cast(taskSet()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTaskSetRequest, T> g) {
        return obj -> g.apply((DeleteTaskSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTaskSetRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set
         * found in to delete.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
         *        set found in to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to delete.
         * </p>
         * 
         * @param service
         *        The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The task set ID or full Amazon Resource Name (ARN) of the task set to delete.
         * </p>
         * 
         * @param taskSet
         *        The task set ID or full Amazon Resource Name (ARN) of the task set to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSet(String taskSet);

        /**
         * <p>
         * If <code>true</code>, you can delete a task set even if it hasn't been scaled down to zero.
         * </p>
         * 
         * @param force
         *        If <code>true</code>, you can delete a task set even if it hasn't been scaled down to zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String service;

        private String taskSet;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTaskSetRequest model) {
            super(model);
            cluster(model.cluster);
            service(model.service);
            taskSet(model.taskSet);
            force(model.force);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getTaskSet() {
            return taskSet;
        }

        public final void setTaskSet(String taskSet) {
            this.taskSet = taskSet;
        }

        @Override
        public final Builder taskSet(String taskSet) {
            this.taskSet = taskSet;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTaskSetRequest build() {
            return new DeleteTaskSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
