/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for a capacity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityProvider.Builder, CapacityProvider> {
    private static final SdkField<String> CAPACITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capacityProviderArn").getter(getter(CapacityProvider::capacityProviderArn))
            .setter(setter(Builder::capacityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CapacityProvider::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CapacityProvider::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<AutoScalingGroupProvider> AUTO_SCALING_GROUP_PROVIDER_FIELD = SdkField
            .<AutoScalingGroupProvider> builder(MarshallingType.SDK_POJO).memberName("autoScalingGroupProvider")
            .getter(getter(CapacityProvider::autoScalingGroupProvider)).setter(setter(Builder::autoScalingGroupProvider))
            .constructor(AutoScalingGroupProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupProvider").build())
            .build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateStatus").getter(getter(CapacityProvider::updateStatusAsString))
            .setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateStatus").build()).build();

    private static final SdkField<String> UPDATE_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateStatusReason").getter(getter(CapacityProvider::updateStatusReason))
            .setter(setter(Builder::updateStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateStatusReason").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CapacityProvider::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_ARN_FIELD,
            NAME_FIELD, STATUS_FIELD, AUTO_SCALING_GROUP_PROVIDER_FIELD, UPDATE_STATUS_FIELD, UPDATE_STATUS_REASON_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String capacityProviderArn;

    private final String name;

    private final String status;

    private final AutoScalingGroupProvider autoScalingGroupProvider;

    private final String updateStatus;

    private final String updateStatusReason;

    private final List<Tag> tags;

    private CapacityProvider(BuilderImpl builder) {
        this.capacityProviderArn = builder.capacityProviderArn;
        this.name = builder.name;
        this.status = builder.status;
        this.autoScalingGroupProvider = builder.autoScalingGroupProvider;
        this.updateStatus = builder.updateStatus;
        this.updateStatusReason = builder.updateStatusReason;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the capacity provider.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the capacity provider.
     */
    public final String capacityProviderArn() {
        return capacityProviderArn;
    }

    /**
     * <p>
     * The name of the capacity provider.
     * </p>
     * 
     * @return The name of the capacity provider.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the capacity provider. Only capacity providers in an <code>ACTIVE</code> state can be used
     * in a cluster. When a capacity provider is successfully deleted, it has an <code>INACTIVE</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapacityProviderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the capacity provider. Only capacity providers in an <code>ACTIVE</code> state can
     *         be used in a cluster. When a capacity provider is successfully deleted, it has an <code>INACTIVE</code>
     *         status.
     * @see CapacityProviderStatus
     */
    public final CapacityProviderStatus status() {
        return CapacityProviderStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the capacity provider. Only capacity providers in an <code>ACTIVE</code> state can be used
     * in a cluster. When a capacity provider is successfully deleted, it has an <code>INACTIVE</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapacityProviderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the capacity provider. Only capacity providers in an <code>ACTIVE</code> state can
     *         be used in a cluster. When a capacity provider is successfully deleted, it has an <code>INACTIVE</code>
     *         status.
     * @see CapacityProviderStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Auto Scaling group settings for the capacity provider.
     * </p>
     * 
     * @return The Auto Scaling group settings for the capacity provider.
     */
    public final AutoScalingGroupProvider autoScalingGroupProvider() {
        return autoScalingGroupProvider;
    }

    /**
     * <p>
     * The update status of the capacity provider. The following are the possible states that is returned.
     * </p>
     * <dl>
     * <dt>DELETE_IN_PROGRESS</dt>
     * <dd>
     * <p>
     * The capacity provider is in the process of being deleted.
     * </p>
     * </dd>
     * <dt>DELETE_COMPLETE</dt>
     * <dd>
     * <p>
     * The capacity provider was successfully deleted and has an <code>INACTIVE</code> status.
     * </p>
     * </dd>
     * <dt>DELETE_FAILED</dt>
     * <dd>
     * <p>
     * The capacity provider can't be deleted. The update status reason provides further details about why the delete
     * failed.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link CapacityProviderUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The update status of the capacity provider. The following are the possible states that is returned.</p>
     *         <dl>
     *         <dt>DELETE_IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         The capacity provider is in the process of being deleted.
     *         </p>
     *         </dd>
     *         <dt>DELETE_COMPLETE</dt>
     *         <dd>
     *         <p>
     *         The capacity provider was successfully deleted and has an <code>INACTIVE</code> status.
     *         </p>
     *         </dd>
     *         <dt>DELETE_FAILED</dt>
     *         <dd>
     *         <p>
     *         The capacity provider can't be deleted. The update status reason provides further details about why the
     *         delete failed.
     *         </p>
     *         </dd>
     * @see CapacityProviderUpdateStatus
     */
    public final CapacityProviderUpdateStatus updateStatus() {
        return CapacityProviderUpdateStatus.fromValue(updateStatus);
    }

    /**
     * <p>
     * The update status of the capacity provider. The following are the possible states that is returned.
     * </p>
     * <dl>
     * <dt>DELETE_IN_PROGRESS</dt>
     * <dd>
     * <p>
     * The capacity provider is in the process of being deleted.
     * </p>
     * </dd>
     * <dt>DELETE_COMPLETE</dt>
     * <dd>
     * <p>
     * The capacity provider was successfully deleted and has an <code>INACTIVE</code> status.
     * </p>
     * </dd>
     * <dt>DELETE_FAILED</dt>
     * <dd>
     * <p>
     * The capacity provider can't be deleted. The update status reason provides further details about why the delete
     * failed.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link CapacityProviderUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The update status of the capacity provider. The following are the possible states that is returned.</p>
     *         <dl>
     *         <dt>DELETE_IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         The capacity provider is in the process of being deleted.
     *         </p>
     *         </dd>
     *         <dt>DELETE_COMPLETE</dt>
     *         <dd>
     *         <p>
     *         The capacity provider was successfully deleted and has an <code>INACTIVE</code> status.
     *         </p>
     *         </dd>
     *         <dt>DELETE_FAILED</dt>
     *         <dd>
     *         <p>
     *         The capacity provider can't be deleted. The update status reason provides further details about why the
     *         delete failed.
     *         </p>
     *         </dd>
     * @see CapacityProviderUpdateStatus
     */
    public final String updateStatusAsString() {
        return updateStatus;
    }

    /**
     * <p>
     * The update status reason. This provides further details about the update status for the capacity provider.
     * </p>
     * 
     * @return The update status reason. This provides further details about the update status for the capacity
     *         provider.
     */
    public final String updateStatusReason() {
        return updateStatusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag consists of
     * a key and an optional value. You define both.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag
     *         consists of a key and an optional value. You define both.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete
     *         tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource
     *         limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupProvider());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityProvider)) {
            return false;
        }
        CapacityProvider other = (CapacityProvider) obj;
        return Objects.equals(capacityProviderArn(), other.capacityProviderArn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(autoScalingGroupProvider(), other.autoScalingGroupProvider())
                && Objects.equals(updateStatusAsString(), other.updateStatusAsString())
                && Objects.equals(updateStatusReason(), other.updateStatusReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityProvider").add("CapacityProviderArn", capacityProviderArn()).add("Name", name())
                .add("Status", statusAsString()).add("AutoScalingGroupProvider", autoScalingGroupProvider())
                .add("UpdateStatus", updateStatusAsString()).add("UpdateStatusReason", updateStatusReason())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacityProviderArn":
            return Optional.ofNullable(clazz.cast(capacityProviderArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "autoScalingGroupProvider":
            return Optional.ofNullable(clazz.cast(autoScalingGroupProvider()));
        case "updateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsString()));
        case "updateStatusReason":
            return Optional.ofNullable(clazz.cast(updateStatusReason()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityProvider, T> g) {
        return obj -> g.apply((CapacityProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityProvider> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the capacity provider.
         * </p>
         * 
         * @param capacityProviderArn
         *        The Amazon Resource Name (ARN) that identifies the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderArn(String capacityProviderArn);

        /**
         * <p>
         * The name of the capacity provider.
         * </p>
         * 
         * @param name
         *        The name of the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the capacity provider. Only capacity providers in an <code>ACTIVE</code> state can be
         * used in a cluster. When a capacity provider is successfully deleted, it has an <code>INACTIVE</code> status.
         * </p>
         * 
         * @param status
         *        The current status of the capacity provider. Only capacity providers in an <code>ACTIVE</code> state
         *        can be used in a cluster. When a capacity provider is successfully deleted, it has an
         *        <code>INACTIVE</code> status.
         * @see CapacityProviderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityProviderStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the capacity provider. Only capacity providers in an <code>ACTIVE</code> state can be
         * used in a cluster. When a capacity provider is successfully deleted, it has an <code>INACTIVE</code> status.
         * </p>
         * 
         * @param status
         *        The current status of the capacity provider. Only capacity providers in an <code>ACTIVE</code> state
         *        can be used in a cluster. When a capacity provider is successfully deleted, it has an
         *        <code>INACTIVE</code> status.
         * @see CapacityProviderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityProviderStatus
         */
        Builder status(CapacityProviderStatus status);

        /**
         * <p>
         * The Auto Scaling group settings for the capacity provider.
         * </p>
         * 
         * @param autoScalingGroupProvider
         *        The Auto Scaling group settings for the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupProvider(AutoScalingGroupProvider autoScalingGroupProvider);

        /**
         * <p>
         * The Auto Scaling group settings for the capacity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingGroupProvider.Builder}
         * avoiding the need to create one manually via {@link AutoScalingGroupProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingGroupProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #autoScalingGroupProvider(AutoScalingGroupProvider)}.
         * 
         * @param autoScalingGroupProvider
         *        a consumer that will call methods on {@link AutoScalingGroupProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingGroupProvider(AutoScalingGroupProvider)
         */
        default Builder autoScalingGroupProvider(Consumer<AutoScalingGroupProvider.Builder> autoScalingGroupProvider) {
            return autoScalingGroupProvider(AutoScalingGroupProvider.builder().applyMutation(autoScalingGroupProvider).build());
        }

        /**
         * <p>
         * The update status of the capacity provider. The following are the possible states that is returned.
         * </p>
         * <dl>
         * <dt>DELETE_IN_PROGRESS</dt>
         * <dd>
         * <p>
         * The capacity provider is in the process of being deleted.
         * </p>
         * </dd>
         * <dt>DELETE_COMPLETE</dt>
         * <dd>
         * <p>
         * The capacity provider was successfully deleted and has an <code>INACTIVE</code> status.
         * </p>
         * </dd>
         * <dt>DELETE_FAILED</dt>
         * <dd>
         * <p>
         * The capacity provider can't be deleted. The update status reason provides further details about why the
         * delete failed.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param updateStatus
         *        The update status of the capacity provider. The following are the possible states that is
         *        returned.</p>
         *        <dl>
         *        <dt>DELETE_IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        The capacity provider is in the process of being deleted.
         *        </p>
         *        </dd>
         *        <dt>DELETE_COMPLETE</dt>
         *        <dd>
         *        <p>
         *        The capacity provider was successfully deleted and has an <code>INACTIVE</code> status.
         *        </p>
         *        </dd>
         *        <dt>DELETE_FAILED</dt>
         *        <dd>
         *        <p>
         *        The capacity provider can't be deleted. The update status reason provides further details about why
         *        the delete failed.
         *        </p>
         *        </dd>
         * @see CapacityProviderUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityProviderUpdateStatus
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * The update status of the capacity provider. The following are the possible states that is returned.
         * </p>
         * <dl>
         * <dt>DELETE_IN_PROGRESS</dt>
         * <dd>
         * <p>
         * The capacity provider is in the process of being deleted.
         * </p>
         * </dd>
         * <dt>DELETE_COMPLETE</dt>
         * <dd>
         * <p>
         * The capacity provider was successfully deleted and has an <code>INACTIVE</code> status.
         * </p>
         * </dd>
         * <dt>DELETE_FAILED</dt>
         * <dd>
         * <p>
         * The capacity provider can't be deleted. The update status reason provides further details about why the
         * delete failed.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param updateStatus
         *        The update status of the capacity provider. The following are the possible states that is
         *        returned.</p>
         *        <dl>
         *        <dt>DELETE_IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        The capacity provider is in the process of being deleted.
         *        </p>
         *        </dd>
         *        <dt>DELETE_COMPLETE</dt>
         *        <dd>
         *        <p>
         *        The capacity provider was successfully deleted and has an <code>INACTIVE</code> status.
         *        </p>
         *        </dd>
         *        <dt>DELETE_FAILED</dt>
         *        <dd>
         *        <p>
         *        The capacity provider can't be deleted. The update status reason provides further details about why
         *        the delete failed.
         *        </p>
         *        </dd>
         * @see CapacityProviderUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityProviderUpdateStatus
         */
        Builder updateStatus(CapacityProviderUpdateStatus updateStatus);

        /**
         * <p>
         * The update status reason. This provides further details about the update status for the capacity provider.
         * </p>
         * 
         * @param updateStatusReason
         *        The update status reason. This provides further details about the update status for the capacity
         *        provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatusReason(String updateStatusReason);

        /**
         * <p>
         * The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag
         * consists of a key and an optional value. You define both.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag
         *        consists of a key and an optional value. You define both.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag
         * consists of a key and an optional value. You define both.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag
         *        consists of a key and an optional value. You define both.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag
         * consists of a key and an optional value. You define both.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ecs.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String capacityProviderArn;

        private String name;

        private String status;

        private AutoScalingGroupProvider autoScalingGroupProvider;

        private String updateStatus;

        private String updateStatusReason;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityProvider model) {
            capacityProviderArn(model.capacityProviderArn);
            name(model.name);
            status(model.status);
            autoScalingGroupProvider(model.autoScalingGroupProvider);
            updateStatus(model.updateStatus);
            updateStatusReason(model.updateStatusReason);
            tags(model.tags);
        }

        public final String getCapacityProviderArn() {
            return capacityProviderArn;
        }

        public final void setCapacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
        }

        @Override
        public final Builder capacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapacityProviderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final AutoScalingGroupProvider.Builder getAutoScalingGroupProvider() {
            return autoScalingGroupProvider != null ? autoScalingGroupProvider.toBuilder() : null;
        }

        public final void setAutoScalingGroupProvider(AutoScalingGroupProvider.BuilderImpl autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider != null ? autoScalingGroupProvider.build() : null;
        }

        @Override
        public final Builder autoScalingGroupProvider(AutoScalingGroupProvider autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider;
            return this;
        }

        public final String getUpdateStatus() {
            return updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(CapacityProviderUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getUpdateStatusReason() {
            return updateStatusReason;
        }

        public final void setUpdateStatusReason(String updateStatusReason) {
            this.updateStatusReason = updateStatusReason;
        }

        @Override
        public final Builder updateStatusReason(String updateStatusReason) {
            this.updateStatusReason = updateStatusReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CapacityProvider build() {
            return new CapacityProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
