/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse;

public class ListTaskDefinitionsPublisher
implements SdkPublisher<ListTaskDefinitionsResponse> {
    private final EcsAsyncClient client;
    private final ListTaskDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTaskDefinitionsPublisher(EcsAsyncClient client, ListTaskDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTaskDefinitionsPublisher(EcsAsyncClient client, ListTaskDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTaskDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTaskDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> taskDefinitionArns() {
        Function<ListTaskDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskDefinitionArns() != null) {
                return response.taskDefinitionArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTaskDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTaskDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListTaskDefinitionsResponse> {
        private ListTaskDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTaskDefinitionsResponse> nextPage(ListTaskDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListTaskDefinitionsPublisher.this.client.listTaskDefinitions(ListTaskDefinitionsPublisher.this.firstRequest);
            }
            return ListTaskDefinitionsPublisher.this.client.listTaskDefinitions((ListTaskDefinitionsRequest)((Object)ListTaskDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

