/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecs.DefaultEcsAsyncClient;
import software.amazon.awssdk.services.ecs.DefaultEcsBaseClientBuilder;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.EcsAsyncClientBuilder;
import software.amazon.awssdk.services.ecs.EcsServiceClientConfiguration;
import software.amazon.awssdk.services.ecs.endpoints.EcsEndpointProvider;

@SdkInternalApi
final class DefaultEcsAsyncClientBuilder
extends DefaultEcsBaseClientBuilder<EcsAsyncClientBuilder, EcsAsyncClient>
implements EcsAsyncClientBuilder {
    DefaultEcsAsyncClientBuilder() {
    }

    @Override
    public DefaultEcsAsyncClientBuilder endpointProvider(EcsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EcsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEcsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        EcsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEcsAsyncClient client = new DefaultEcsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EcsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EcsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

