/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse;
import software.amazon.awssdk.services.ecs.model.Setting;

public class ListAccountSettingsIterable
implements SdkIterable<ListAccountSettingsResponse> {
    private final EcsClient client;
    private final ListAccountSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountSettingsIterable(EcsClient client, ListAccountSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountSettingsResponseFetcher();
    }

    public Iterator<ListAccountSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Setting> settings() {
        Function<ListAccountSettingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.settings() != null) {
                return response.settings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountSettingsResponseFetcher
    implements SyncPageFetcher<ListAccountSettingsResponse> {
        private ListAccountSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountSettingsResponse nextPage(ListAccountSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountSettingsIterable.this.client.listAccountSettings(ListAccountSettingsIterable.this.firstRequest);
            }
            return ListAccountSettingsIterable.this.client.listAccountSettings((ListAccountSettingsRequest)((Object)ListAccountSettingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

