/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LaunchType {
    EC2("EC2"),
    FARGATE("FARGATE"),
    EXTERNAL("EXTERNAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LaunchType> VALUE_MAP;
    private final String value;

    private LaunchType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchType> knownValues() {
        EnumSet<LaunchType> knownValues = EnumSet.allOf(LaunchType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LaunchType.class, LaunchType::toString);
    }
}

